/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class Header {
    private final String name;
    private final List<String> values;
    private volatile String cachedStringValue;
    private static final AtomicReferenceFieldUpdater<Header, String> CACHED_STRING_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Header.class, String.class, "cachedStringValue");

    public Header(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<String>();
        this.values.add(value);
    }

    public Header(String name, String ... values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<String>();
        Collections.addAll(this.values, values);
    }

    public Header(String name, List<String> values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<String>(values);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        this.checkCachedStringValue();
        return CACHED_STRING_VALUE_UPDATER.get(this);
    }

    public String[] getValues() {
        return this.values.toArray(new String[0]);
    }

    public List<String> getValuesList() {
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(String value) {
        this.values.add(value);
        CACHED_STRING_VALUE_UPDATER.set(this, null);
    }

    public String toString() {
        this.checkCachedStringValue();
        return this.name + ":" + CACHED_STRING_VALUE_UPDATER.get(this);
    }

    private void checkCachedStringValue() {
        CACHED_STRING_VALUE_UPDATER.compareAndSet(this, null, CoreUtils.stringJoin(",", this.values));
    }
}

