/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FluxByteBufferContent
extends BinaryDataContent {
    private final Flux<ByteBuffer> content;
    private final AtomicReference<byte[]> bytes = new AtomicReference();
    private final AtomicReference<FluxByteBufferContent> cachedReplayableContent = new AtomicReference();
    private final Long length;
    private final boolean isReplayable;

    public FluxByteBufferContent(Flux<ByteBuffer> content) {
        this(content, null);
    }

    public FluxByteBufferContent(Flux<ByteBuffer> content, Long length) {
        this(content, length, false);
    }

    private FluxByteBufferContent(Flux<ByteBuffer> content, Long length, boolean isReplayable) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
        this.length = length;
        this.isReplayable = isReplayable;
    }

    @Override
    public Long getLength() {
        if (this.bytes.get() != null) {
            return this.bytes.get().length;
        }
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        byte[] data = this.bytes.get();
        if (data == null) {
            this.bytes.set(this.getBytes());
            data = this.bytes.get();
        }
        return data;
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.toBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content;
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        if (this.isReplayable) {
            return this;
        }
        FluxByteBufferContent replayableContent = this.cachedReplayableContent.get();
        if (replayableContent != null) {
            return replayableContent;
        }
        Flux bufferedFlux = this.content.map(buffer -> {
            ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
            copy.put((ByteBuffer)buffer);
            copy.flip();
            return copy;
        }).collect(LinkedList::new, LinkedList::add).cache().flatMapMany(listOfBuffers -> Flux.fromIterable((Iterable)listOfBuffers).map(ByteBuffer::duplicate));
        replayableContent = new FluxByteBufferContent((Flux<ByteBuffer>)bufferedFlux, this.length, true);
        this.cachedReplayableContent.set(replayableContent);
        return replayableContent;
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        return Mono.fromCallable(this::toReplayableContent);
    }

    private byte[] getBytes() {
        return (byte[])FluxUtil.collectBytesInByteBufferStream(this.content).share().block();
    }
}

