/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.implementation.logging.DefaultLogger;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.LogLevel;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class ClientLogger {
    private final Logger logger;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        Logger initLogger = LoggerFactory.getLogger((String)className);
        this.logger = initLogger instanceof NOPLogger ? new DefaultLogger(className) : initLogger;
    }

    public void verbose(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.performLogging(LogLevel.VERBOSE, false, format, args);
        }
    }

    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.performLogging(LogLevel.INFORMATIONAL, false, format, args);
        }
    }

    public void warning(String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, false, format, args);
        }
    }

    public void error(String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.performLogging(LogLevel.ERROR, false, format, args);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (!this.logger.isWarnEnabled()) {
            return runtimeException;
        }
        this.performLogging(LogLevel.WARNING, true, runtimeException.getMessage(), runtimeException);
        return runtimeException;
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (!this.logger.isErrorEnabled()) {
            return runtimeException;
        }
        this.performLogging(LogLevel.VERBOSE, true, runtimeException.getMessage(), runtimeException);
        return runtimeException;
    }

    private void performLogging(LogLevel logLevel, boolean isExceptionLogging, String format, Object ... args) {
        String throwableMessage = "";
        if (this.doesArgsHaveThrowable(args)) {
            Object throwable;
            if (!isExceptionLogging && (throwable = args[args.length - 1]) instanceof Throwable) {
                throwableMessage = ((Throwable)throwable).getMessage();
            }
            if (!this.logger.isDebugEnabled()) {
                args = this.removeThrowable(args);
            }
        }
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(format, args);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(format, args);
                break;
            }
            case WARNING: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.warn(format, args);
                break;
            }
            case ERROR: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.error(format, args);
                break;
            }
        }
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        switch (logLevel) {
            case VERBOSE: {
                return this.logger.isDebugEnabled();
            }
            case INFORMATIONAL: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private boolean doesArgsHaveThrowable(Object ... args) {
        if (args.length == 0) {
            return false;
        }
        return args[args.length - 1] instanceof Throwable;
    }

    private Object[] removeThrowable(Object ... args) {
        return Arrays.copyOf(args, args.length - 1);
    }
}

