/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

public final class FileWriteSubscriber
implements Subscriber<ByteBuffer> {
    private volatile boolean isWriting = false;
    private volatile boolean isCompleted = false;
    private static final ClientLogger LOGGER = new ClientLogger(FileWriteSubscriber.class);
    private final AsynchronousFileChannel fileChannel;
    private final AtomicLong position;
    private final MonoSink<Void> emitter;
    private Subscription subscription;

    public FileWriteSubscriber(AsynchronousFileChannel fileChannel, long position, MonoSink<Void> emitter) {
        this.fileChannel = fileChannel;
        this.position = new AtomicLong(position);
        this.emitter = emitter;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
            this.subscription = s;
            s.request(1L);
        }
    }

    public void onNext(ByteBuffer bytes) {
        try {
            if (this.isWriting) {
                this.onError(new IllegalStateException("Received onNext while processing another write operation."));
            } else {
                this.write(bytes);
            }
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    private void write(final ByteBuffer bytes) {
        this.isWriting = true;
        this.fileChannel.write(bytes, this.position.get(), bytes, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                FileWriteSubscriber.this.position.addAndGet(result.intValue());
                if (bytes.hasRemaining()) {
                    FileWriteSubscriber.this.write(bytes);
                } else {
                    FileWriteSubscriber.this.isWriting = false;
                    if (FileWriteSubscriber.this.isCompleted) {
                        FileWriteSubscriber.this.emitter.success();
                    } else {
                        FileWriteSubscriber.this.subscription.request(1L);
                    }
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                FileWriteSubscriber.this.onError(exc);
            }
        });
    }

    public void onError(Throwable throwable) {
        this.isWriting = false;
        this.subscription.cancel();
        this.emitter.error(LOGGER.logThrowableAsError(throwable));
    }

    public void onComplete() {
        this.isCompleted = true;
        if (!this.isWriting) {
            this.emitter.success();
        }
    }
}

