/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.implementation.LoggingUtil;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.LogLevel;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLogger {
    private final Logger logger;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        this.logger = LoggerFactory.getLogger((String)className);
    }

    public void verbose(String format, Object ... args) {
        this.log(LogLevel.VERBOSE, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(LogLevel.INFORMATIONAL, format, args);
    }

    public void warning(String format, Object ... args) {
        this.log(LogLevel.WARNING, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(LogLevel.ERROR, format, args);
    }

    private void log(LogLevel logLevel, String format, Object ... args) {
        LogLevel environmentLoggingLevel = LoggingUtil.getEnvironmentLoggingLevel();
        if (this.canLogAtLevel(logLevel, environmentLoggingLevel)) {
            this.performLogging(logLevel, environmentLoggingLevel, false, format, args);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        return this.logException(runtimeException, LogLevel.WARNING);
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        return this.logException(runtimeException, LogLevel.ERROR);
    }

    private RuntimeException logException(RuntimeException runtimeException, LogLevel logLevel) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        LogLevel environmentLoggingLevel = LoggingUtil.getEnvironmentLoggingLevel();
        if (this.canLogAtLevel(logLevel, environmentLoggingLevel)) {
            this.performLogging(logLevel, environmentLoggingLevel, true, runtimeException.getMessage(), runtimeException);
        }
        return runtimeException;
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        return this.canLogAtLevel(logLevel, LoggingUtil.getEnvironmentLoggingLevel());
    }

    private void performLogging(LogLevel logLevel, LogLevel environmentLogLevel, boolean isExceptionLogging, String format, Object ... args) {
        String throwableMessage = "";
        if (this.doesArgsHaveThrowable(args)) {
            Object throwable;
            if (!isExceptionLogging && (throwable = args[args.length - 1]) instanceof Throwable) {
                throwableMessage = ((Throwable)throwable).getMessage();
            }
            if (environmentLogLevel.getLogLevel() > LogLevel.VERBOSE.getLogLevel()) {
                args = this.removeThrowable(args);
            }
        }
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(format, args);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(format, args);
                break;
            }
            case WARNING: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.warn(format, args);
                break;
            }
            case ERROR: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.error(format, args);
                break;
            }
        }
    }

    private boolean canLogAtLevel(LogLevel logLevel, LogLevel environmentLoggingLevel) {
        if (logLevel == null) {
            return false;
        }
        if (logLevel.getLogLevel() < environmentLoggingLevel.getLogLevel()) {
            return false;
        }
        switch (logLevel) {
            case VERBOSE: {
                return this.logger.isDebugEnabled();
            }
            case INFORMATIONAL: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private boolean doesArgsHaveThrowable(Object ... args) {
        if (args.length == 0) {
            return false;
        }
        return args[args.length - 1] instanceof Throwable;
    }

    private Object[] removeThrowable(Object ... args) {
        return Arrays.copyOf(args, args.length - 1);
    }
}

