/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.tracing;

import com.azure.core.util.Context;
import com.azure.core.util.tracing.Tracer;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class TracerProxy {
    private static Tracer tracer;

    private TracerProxy() {
    }

    public static Context start(String methodName, Context context) {
        if (tracer == null) {
            return context;
        }
        return tracer.start(methodName, context);
    }

    public static void setAttribute(String key, String value, Context context) {
        if (tracer == null) {
            return;
        }
        tracer.setAttribute(key, value, context);
    }

    public static void end(int responseCode, Throwable error, Context context) {
        if (tracer == null) {
            return;
        }
        tracer.end(responseCode, error, context);
    }

    public static Context setSpanName(String spanName, Context context) {
        if (tracer == null) {
            return context;
        }
        return tracer.setSpanName(spanName, context);
    }

    public static boolean isTracingEnabled() {
        return tracer != null;
    }

    static {
        ServiceLoader<Tracer> serviceLoader = ServiceLoader.load(Tracer.class);
        Iterator<Tracer> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            tracer = serviceLoader.iterator().next();
        }
    }
}

