/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class HttpClientProviders {
    private static final String CANNOT_FIND_HTTP_CLIENT = "A request was made to load the default HttpClient provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-http-netty or azure-core-http-okhttp. Depending on your existing dependencies, you have the choice of Netty or OkHttp implementations. Additionally, refer to https://aka.ms/azsdk/java/docs/custom-httpclient to learn about writing your own implementation.";
    private static HttpClientProvider defaultProvider;

    private HttpClientProviders() {
    }

    public static HttpClient createInstance() {
        return HttpClientProviders.createInstance(null);
    }

    public static HttpClient createInstance(ClientOptions clientOptions) {
        if (defaultProvider == null) {
            throw new IllegalStateException(CANNOT_FIND_HTTP_CLIENT);
        }
        if (clientOptions instanceof HttpClientOptions) {
            return defaultProvider.createInstance((HttpClientOptions)clientOptions);
        }
        return defaultProvider.createInstance();
    }

    static {
        ServiceLoader<HttpClientProvider> serviceLoader = ServiceLoader.load(HttpClientProvider.class);
        Iterator<HttpClientProvider> it = serviceLoader.iterator();
        if (it.hasNext()) {
            defaultProvider = it.next();
        }
    }
}

