/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final Mono<byte[]> cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        super(innerHttpResponse.getRequest());
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.getBodyAsByteArray().cache();
    }

    @Override
    public int getStatusCode() {
        return this.innerHttpResponse.getStatusCode();
    }

    @Override
    public String getHeaderValue(String name) {
        return this.innerHttpResponse.getHeaderValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.innerHttpResponse.getHeaders();
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return this.cachedBody;
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        return this.getBodyAsByteArray().flatMapMany(bytes -> Flux.just((Object)ByteBuffer.wrap(bytes)));
    }

    @Override
    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    @Override
    public Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, charset));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

