/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.EncodedParameter;
import com.azure.core.http.rest.MissingRequiredAnnotationException;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PercentEscaper;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.Substitution;
import com.azure.core.http.rest.UrlEscapers;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.util.Base64Url;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SwaggerMethodParser
implements HttpResponseDecodeData {
    private final SerializerAdapter serializer;
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private final HttpMethod httpMethod;
    private final String relativePath;
    private final List<Substitution> hostSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> pathSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> querySubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> formSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> headerSubstitutions = new ArrayList<Substitution>();
    private final HttpHeaders headers = new HttpHeaders();
    private final Integer bodyContentMethodParameterIndex;
    private final String bodyContentType;
    private final Type bodyJavaType;
    private final int[] expectedStatusCodes;
    private final Type returnType;
    private final Type returnValueWireType;
    private final UnexpectedResponseExceptionType[] unexpectedResponseExceptionTypes;
    private Map<Integer, UnexpectedExceptionInformation> exceptionMapping;
    private UnexpectedExceptionInformation defaultException;

    SwaggerMethodParser(Method swaggerMethod, String rawHost) {
        ExpectedResponses expectedResponses;
        Class<?> returnValueWireType;
        this.serializer = JacksonAdapter.createDefaultSerializerAdapter();
        this.rawHost = rawHost;
        Class<?> swaggerInterface = swaggerMethod.getDeclaringClass();
        this.fullyQualifiedMethodName = swaggerInterface.getName() + "." + swaggerMethod.getName();
        if (swaggerMethod.isAnnotationPresent(Get.class)) {
            this.httpMethod = HttpMethod.GET;
            this.relativePath = swaggerMethod.getAnnotation(Get.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Put.class)) {
            this.httpMethod = HttpMethod.PUT;
            this.relativePath = swaggerMethod.getAnnotation(Put.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Head.class)) {
            this.httpMethod = HttpMethod.HEAD;
            this.relativePath = swaggerMethod.getAnnotation(Head.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Delete.class)) {
            this.httpMethod = HttpMethod.DELETE;
            this.relativePath = swaggerMethod.getAnnotation(Delete.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Post.class)) {
            this.httpMethod = HttpMethod.POST;
            this.relativePath = swaggerMethod.getAnnotation(Post.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Patch.class)) {
            this.httpMethod = HttpMethod.PATCH;
            this.relativePath = swaggerMethod.getAnnotation(Patch.class).value();
        } else {
            this.httpMethod = null;
            this.relativePath = null;
            ArrayList<Class<? extends Annotation>> requiredAnnotationOptions = new ArrayList<Class<? extends Annotation>>();
            requiredAnnotationOptions.add(Get.class);
            requiredAnnotationOptions.add(Put.class);
            requiredAnnotationOptions.add(Head.class);
            requiredAnnotationOptions.add(Delete.class);
            requiredAnnotationOptions.add(Post.class);
            requiredAnnotationOptions.add(Patch.class);
            throw new MissingRequiredAnnotationException(requiredAnnotationOptions, swaggerMethod);
        }
        this.returnType = swaggerMethod.getGenericReturnType();
        ReturnValueWireType returnValueWireTypeAnnotation = swaggerMethod.getAnnotation(ReturnValueWireType.class);
        this.returnValueWireType = returnValueWireTypeAnnotation != null ? ((returnValueWireType = returnValueWireTypeAnnotation.value()) == Base64Url.class || returnValueWireType == UnixTime.class || returnValueWireType == DateTimeRfc1123.class ? returnValueWireType : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, List.class) ? returnValueWireType.getGenericInterfaces()[0] : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, Page.class) ? returnValueWireType : null))) : null;
        if (swaggerMethod.isAnnotationPresent(Headers.class)) {
            String[] headers;
            Headers headersAnnotation = swaggerMethod.getAnnotation(Headers.class);
            for (String header : headers = headersAnnotation.value()) {
                String headerValue;
                String headerName;
                int colonIndex = header.indexOf(":");
                if (colonIndex < 0 || (headerName = header.substring(0, colonIndex).trim()).isEmpty() || (headerValue = header.substring(colonIndex + 1).trim()).isEmpty()) continue;
                this.headers.put(headerName, headerValue);
            }
        }
        this.expectedStatusCodes = (expectedResponses = swaggerMethod.getAnnotation(ExpectedResponses.class)) == null ? null : expectedResponses.value();
        this.unexpectedResponseExceptionTypes = (UnexpectedResponseExceptionType[])swaggerMethod.getAnnotationsByType(UnexpectedResponseExceptionType.class);
        Integer bodyContentMethodParameterIndex = null;
        String bodyContentType = null;
        Object bodyJavaType = null;
        Annotation[][] allParametersAnnotations = swaggerMethod.getParameterAnnotations();
        for (int parameterIndex = 0; parameterIndex < allParametersAnnotations.length; ++parameterIndex) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = swaggerMethod.getParameterAnnotations()[parameterIndex]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(HostParam.class)) {
                    HostParam hostParamAnnotation = (HostParam)annotation;
                    this.hostSubstitutions.add(new Substitution(hostParamAnnotation.value(), parameterIndex, !hostParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(PathParam.class)) {
                    PathParam pathParamAnnotation = (PathParam)annotation;
                    this.pathSubstitutions.add(new Substitution(pathParamAnnotation.value(), parameterIndex, !pathParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(QueryParam.class)) {
                    QueryParam queryParamAnnotation = (QueryParam)annotation;
                    this.querySubstitutions.add(new Substitution(queryParamAnnotation.value(), parameterIndex, !queryParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(HeaderParam.class)) {
                    HeaderParam headerParamAnnotation = (HeaderParam)annotation;
                    this.headerSubstitutions.add(new Substitution(headerParamAnnotation.value(), parameterIndex, false));
                    continue;
                }
                if (annotationType.equals(BodyParam.class)) {
                    BodyParam bodyParamAnnotation = (BodyParam)annotation;
                    bodyContentMethodParameterIndex = parameterIndex;
                    bodyContentType = bodyParamAnnotation.value();
                    bodyJavaType = swaggerMethod.getGenericParameterTypes()[parameterIndex];
                    continue;
                }
                if (!annotationType.equals(FormParam.class)) continue;
                FormParam formParamAnnotation = (FormParam)annotation;
                this.formSubstitutions.add(new Substitution(formParamAnnotation.value(), parameterIndex, !formParamAnnotation.encoded()));
                bodyContentType = "application/x-www-form-urlencoded";
                bodyJavaType = String.class;
            }
        }
        this.bodyContentMethodParameterIndex = bodyContentMethodParameterIndex;
        this.bodyContentType = bodyContentType;
        this.bodyJavaType = bodyJavaType;
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public int[] getExpectedStatusCodes() {
        return CoreUtils.clone(this.expectedStatusCodes);
    }

    public String setScheme(Object[] swaggerMethodArguments) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, UrlEscapers.PATH_ESCAPER);
        String[] substitutedHostParts = substitutedHost.split("://");
        return substitutedHostParts.length < 1 ? null : substitutedHostParts[0];
    }

    public String setHost(Object[] swaggerMethodArguments) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, UrlEscapers.PATH_ESCAPER);
        String[] substitutedHostParts = substitutedHost.split("://");
        return substitutedHostParts.length < 2 ? substitutedHost : substitutedHost.split("://")[1];
    }

    public String setPath(Object[] methodArguments) {
        return this.applySubstitutions(this.relativePath, this.pathSubstitutions, methodArguments, UrlEscapers.PATH_ESCAPER);
    }

    public Iterable<EncodedParameter> setEncodedQueryParameters(Object[] swaggerMethodArguments) {
        return this.encodeParameters(swaggerMethodArguments, this.querySubstitutions);
    }

    public Iterable<EncodedParameter> setEncodedFormParameters(Object[] swaggerMethodArguments) {
        return this.encodeParameters(swaggerMethodArguments, this.formSubstitutions);
    }

    private Iterable<EncodedParameter> encodeParameters(Object[] swaggerMethodArguments, List<Substitution> substitutions) {
        if (substitutions == null) {
            return Collections.emptyList();
        }
        ArrayList<EncodedParameter> result = new ArrayList<EncodedParameter>();
        PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
        for (Substitution substitution : substitutions) {
            Object methodArgument;
            String parameterValue;
            int parameterIndex = substitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length || (parameterValue = this.serialize(methodArgument = swaggerMethodArguments[substitution.getMethodParameterIndex()])) == null) continue;
            if (substitution.shouldEncode() && escaper != null) {
                parameterValue = escaper.escape(parameterValue);
            }
            result.add(new EncodedParameter(substitution.getUrlParameterName(), parameterValue));
        }
        return result;
    }

    public Iterable<HttpHeader> setHeaders(Object[] swaggerMethodArguments) {
        HttpHeaders result = new HttpHeaders(this.headers);
        if (this.headerSubstitutions != null) {
            for (Substitution headerSubstitution : this.headerSubstitutions) {
                int parameterIndex = headerSubstitution.getMethodParameterIndex();
                if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
                Object methodArgument = swaggerMethodArguments[headerSubstitution.getMethodParameterIndex()];
                if (methodArgument instanceof Map) {
                    Map headerCollection = (Map)methodArgument;
                    String headerCollectionPrefix = headerSubstitution.getUrlParameterName();
                    for (Map.Entry headerCollectionEntry : headerCollection.entrySet()) {
                        String headerName = headerCollectionPrefix + (String)headerCollectionEntry.getKey();
                        String headerValue = this.serialize(headerCollectionEntry.getValue());
                        result.put(headerName, headerValue);
                    }
                    continue;
                }
                String headerName = headerSubstitution.getUrlParameterName();
                String headerValue = this.serialize(methodArgument);
                result.put(headerName, headerValue);
            }
        }
        return result;
    }

    public Context setContext(Object[] swaggerMethodArguments) {
        Context context = CoreUtils.findFirstOfType(swaggerMethodArguments, Context.class);
        return context != null ? context : Context.NONE;
    }

    public boolean isExpectedResponseStatusCode(int responseStatusCode, int[] additionalAllowedStatusCodes) {
        boolean result = this.expectedStatusCodes == null ? responseStatusCode < 400 : SwaggerMethodParser.contains(this.expectedStatusCodes, responseStatusCode) || SwaggerMethodParser.contains(additionalAllowedStatusCodes, responseStatusCode);
        return result;
    }

    private static boolean contains(int[] values, int searchValue) {
        boolean result = false;
        if (values != null && values.length > 0) {
            for (int value : values) {
                if (searchValue != value) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public UnexpectedExceptionInformation getUnexpectedException(int code) {
        if (this.exceptionMapping == null) {
            this.exceptionMapping = this.processUnexpectedResponseExceptionTypes();
        }
        return this.exceptionMapping.getOrDefault(code, this.defaultException);
    }

    public Object setBody(Object[] swaggerMethodArguments) {
        Object result = null;
        if (this.bodyContentMethodParameterIndex != null && swaggerMethodArguments != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < swaggerMethodArguments.length) {
            result = swaggerMethodArguments[this.bodyContentMethodParameterIndex];
        }
        if (this.formSubstitutions != null && !this.formSubstitutions.isEmpty() && swaggerMethodArguments != null) {
            result = this.formSubstitutions.stream().map(s -> this.serializeFormData(s.getUrlParameterName(), swaggerMethodArguments[s.getMethodParameterIndex()])).collect(Collectors.joining("&"));
        }
        return result;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    public Type getBodyJavaType() {
        return this.bodyJavaType;
    }

    @Override
    public Type getReturnValueWireType() {
        return this.returnValueWireType;
    }

    public boolean expectsResponseBody() {
        boolean result = true;
        if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Void.class)) {
            result = false;
        } else if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Mono.class) || TypeUtil.isTypeOrSubTypeOf(this.returnType, Flux.class)) {
            ParameterizedType asyncReturnType = (ParameterizedType)this.returnType;
            Type syncReturnType = asyncReturnType.getActualTypeArguments()[0];
            if (TypeUtil.isTypeOrSubTypeOf(syncReturnType, Void.class)) {
                result = false;
            } else if (TypeUtil.isTypeOrSubTypeOf(syncReturnType, Response.class)) {
                result = TypeUtil.restResponseTypeExpectsBody((ParameterizedType)TypeUtil.getSuperType(syncReturnType, Response.class));
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Response.class)) {
            result = TypeUtil.restResponseTypeExpectsBody((ParameterizedType)this.returnType);
        }
        return result;
    }

    private String serialize(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : this.serializer.serializeRaw(value);
        }
        return result;
    }

    private String serializeFormData(String key, Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof List ? ((List)value).stream().map(el -> String.format("%s=%s", key, this.serialize(el))).collect(Collectors.joining("&")) : String.format("%s=%s", key, this.serializer.serializeRaw(value));
        }
        return result;
    }

    private String applySubstitutions(String originalValue, Iterable<Substitution> substitutions, Object[] methodArguments, PercentEscaper escaper) {
        String result = originalValue;
        if (methodArguments != null) {
            for (Substitution substitution : substitutions) {
                int substitutionParameterIndex = substitution.getMethodParameterIndex();
                if (0 > substitutionParameterIndex || substitutionParameterIndex >= methodArguments.length) continue;
                Object methodArgument = methodArguments[substitutionParameterIndex];
                String substitutionValue = this.serialize(methodArgument);
                if (substitutionValue != null && !substitutionValue.isEmpty() && substitution.shouldEncode() && escaper != null) {
                    substitutionValue = escaper.escape(substitutionValue);
                }
                if (substitutionValue == null) {
                    substitutionValue = "";
                }
                result = result.replace("{" + substitution.getUrlParameterName() + "}", substitutionValue);
            }
        }
        return result;
    }

    private Map<Integer, UnexpectedExceptionInformation> processUnexpectedResponseExceptionTypes() {
        HashMap<Integer, UnexpectedExceptionInformation> exceptionHashMap = new HashMap<Integer, UnexpectedExceptionInformation>();
        for (UnexpectedResponseExceptionType exceptionAnnotation : this.unexpectedResponseExceptionTypes) {
            UnexpectedExceptionInformation exception = new UnexpectedExceptionInformation(exceptionAnnotation.value());
            if (exceptionAnnotation.code().length == 0) {
                this.defaultException = exception;
                continue;
            }
            for (int statusCode : exceptionAnnotation.code()) {
                exceptionHashMap.put(statusCode, exception);
            }
        }
        if (this.defaultException == null) {
            this.defaultException = new UnexpectedExceptionInformation(HttpResponseException.class);
        }
        return exceptionHashMap;
    }
}

