/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.exception;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

public class MissingRequiredAnnotationException
extends RuntimeException {
    public MissingRequiredAnnotationException(Class<? extends Annotation> requiredAnnotation, Class<?> swaggerInterface) {
        super("A " + MissingRequiredAnnotationException.getAnnotationName(requiredAnnotation) + " annotation must be defined on " + swaggerInterface.getName() + ".");
    }

    public MissingRequiredAnnotationException(Class<? extends Annotation> requiredAnnotation, Method swaggerInterfaceMethod) {
        super("A " + MissingRequiredAnnotationException.getAnnotationName(requiredAnnotation) + " annotation must be defined on the method " + MissingRequiredAnnotationException.methodFullName(swaggerInterfaceMethod) + ".");
    }

    public MissingRequiredAnnotationException(List<Class<? extends Annotation>> requiredAnnotationOptions, Method swaggerInterfaceMethod) {
        super("Either " + MissingRequiredAnnotationException.optionsToString(requiredAnnotationOptions) + " annotation must be defined on the method " + MissingRequiredAnnotationException.methodFullName(swaggerInterfaceMethod) + ".");
    }

    private static String getAnnotationName(Class<? extends Annotation> annotation) {
        return annotation.getSimpleName();
    }

    private static String optionsToString(List<Class<? extends Annotation>> requiredAnnotationOptions) {
        StringBuilder result = new StringBuilder();
        int optionCount = requiredAnnotationOptions.size();
        for (int i = 0; i < optionCount; ++i) {
            if (1 <= i) {
                result.append(", ");
            }
            if (i == optionCount - 1) {
                result.append("or ");
            }
            result.append(MissingRequiredAnnotationException.getAnnotationName(requiredAnnotationOptions.get(i)));
        }
        return result.toString();
    }

    private static String methodFullName(Method swaggerInterfaceMethod) {
        return swaggerInterfaceMethod.getDeclaringClass().getName() + "." + swaggerInterfaceMethod.getName() + "()";
    }
}

