/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.annotation.Host;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.implementation.SwaggerMethodParser;
import com.azure.core.implementation.exception.MissingRequiredAnnotationException;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.util.ImplUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SwaggerInterfaceParser {
    private final String host;
    private final String serviceName;
    private static final Map<Method, SwaggerMethodParser> METHOD_PARSERS = new ConcurrentHashMap<Method, SwaggerMethodParser>();

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter serializer) {
        this(swaggerInterface, serializer, null);
    }

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter serializer, String host) {
        if (!ImplUtils.isNullOrEmpty(host)) {
            this.host = host;
        } else {
            Host hostAnnotation = swaggerInterface.getAnnotation(Host.class);
            if (hostAnnotation != null && !hostAnnotation.value().isEmpty()) {
                this.host = hostAnnotation.value();
            } else {
                throw new MissingRequiredAnnotationException(Host.class, swaggerInterface);
            }
        }
        ServiceInterface serviceAnnotation = swaggerInterface.getAnnotation(ServiceInterface.class);
        if (serviceAnnotation == null || serviceAnnotation.name().isEmpty()) {
            throw new MissingRequiredAnnotationException(ServiceInterface.class, swaggerInterface);
        }
        this.serviceName = serviceAnnotation.name();
    }

    public SwaggerMethodParser getMethodParser(Method swaggerMethod) {
        SwaggerMethodParser result = METHOD_PARSERS.get(swaggerMethod);
        if (result == null) {
            result = new SwaggerMethodParser(swaggerMethod, this.getHost());
            METHOD_PARSERS.put(swaggerMethod, result);
        }
        return result;
    }

    String getHost() {
        return this.host;
    }

    String getServiceName() {
        return this.serviceName;
    }
}

