/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils.metrics;

import com.azure.core.test.utils.metrics.TestMeasurement;
import com.azure.core.test.utils.metrics.TestTelemetryAttributes;
import com.azure.core.util.Context;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.LongCounter;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class TestCounter
implements LongCounter {
    private final ConcurrentLinkedQueue<TestMeasurement<Long>> measurements = new ConcurrentLinkedQueue();
    private final boolean isEnabled;

    TestCounter(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void add(long value, TelemetryAttributes attributes, Context context) {
        if (this.isEnabled) {
            this.measurements.add(new TestMeasurement<Long>(value, (TestTelemetryAttributes)attributes, context));
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public List<TestMeasurement<Long>> getMeasurements() {
        return this.measurements.stream().collect(Collectors.toList());
    }
}

