/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class RecordFilePayload
implements JsonSerializable<RecordFilePayload> {
    private final String recordingFile;
    private final String assetFile;

    public RecordFilePayload(String recordingFile, String assetFile) {
        this.recordingFile = recordingFile;
        this.assetFile = assetFile;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("x-recording-file", this.recordingFile).writeStringField("x-recording-assets-file", this.assetFile).writeEndObject();
    }

    public static RecordFilePayload fromJson(JsonReader jsonReader) throws IOException {
        return (RecordFilePayload)jsonReader.readObject(reader -> {
            String recordingFile = null;
            String assetFile = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x-recording-file".equals(fieldName)) {
                    recordingFile = reader.getString();
                    continue;
                }
                if ("x-recording-assets-file".equals(fieldName)) {
                    assetFile = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new RecordFilePayload(recordingFile, assetFile);
        });
    }
}

