/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation.models;

import com.azure.core.test.implementation.models.PizzaSize;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HttpBinFormDataJson
implements JsonSerializable<HttpBinFormDataJson> {
    private String url;
    private Map<String, String> headers;
    private Form form;

    public String url() {
        return this.url;
    }

    public void url(String url) {
        this.url = url;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public void headers(Map<String, String> headers) {
        this.headers = headers;
    }

    public Form form() {
        return this.form;
    }

    public void form(Form form) {
        this.form = form;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("url", this.url).writeMapField("headers", this.headers, JsonWriter::writeString).writeJsonField("form", (JsonSerializable)this.form).writeEndObject();
    }

    public static HttpBinFormDataJson fromJson(JsonReader jsonReader) throws IOException {
        return (HttpBinFormDataJson)jsonReader.readObject(reader -> {
            HttpBinFormDataJson form = new HttpBinFormDataJson();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    form.url = reader.getString();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    form.headers = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("form".equals(fieldName)) {
                    form.form = Form.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return form;
        });
    }

    public static class Form
    implements JsonSerializable<Form> {
        private String customerName;
        private String customerTelephone;
        private String customerEmail;
        private PizzaSize pizzaSize;
        private List<String> toppings;

        public String customerName() {
            return this.customerName;
        }

        public void customerName(String customerName) {
            this.customerName = customerName;
        }

        public String customerTelephone() {
            return this.customerTelephone;
        }

        public void customerTelephone(String customerTelephone) {
            this.customerTelephone = customerTelephone;
        }

        public String customerEmail() {
            return this.customerEmail;
        }

        public void customerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
        }

        public PizzaSize pizzaSize() {
            return this.pizzaSize;
        }

        public void pizzaSize(PizzaSize pizzaSize) {
            this.pizzaSize = pizzaSize;
        }

        public List<String> toppings() {
            return this.toppings;
        }

        public void toppings(List<String> toppings) {
            this.toppings = toppings;
        }

        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeStringField("custname", this.customerName).writeStringField("custtel", this.customerTelephone).writeStringField("custemail", this.customerEmail).writeStringField("size", Objects.toString((Object)this.pizzaSize, null)).writeArrayField("toppings", this.toppings, JsonWriter::writeString).writeEndObject();
        }

        public static Form fromJson(JsonReader jsonReader) throws IOException {
            return (Form)jsonReader.readObject(reader -> {
                Form form = new Form();
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("custname".equals(fieldName)) {
                        form.customerName = reader.getString();
                        continue;
                    }
                    if ("custtel".equals(fieldName)) {
                        form.customerTelephone = reader.getString();
                        continue;
                    }
                    if ("custemail".equals(fieldName)) {
                        form.customerEmail = reader.getString();
                        continue;
                    }
                    if ("size".equals(fieldName)) {
                        form.pizzaSize = PizzaSize.fromString(reader.getString());
                        continue;
                    }
                    if ("toppings".equals(fieldName)) {
                        form.toppings = reader.readArray(JsonReader::getString);
                        continue;
                    }
                    reader.skipChildren();
                }
                return form;
            });
        }
    }
}

