/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.utils.ResourceNamer;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TestResourceNamer
extends ResourceNamer {
    private final boolean allowedToReadRecordedValues;
    private final boolean allowedToRecordValues;
    private final Consumer<String> storeVariable;
    private final Supplier<String> getVariable;

    @Deprecated
    public TestResourceNamer(String name, TestMode testMode, RecordedData storage) {
        this(name, testMode, false, null, null, storage);
    }

    public TestResourceNamer(TestContextManager testContextManager, RecordedData storage) {
        this(testContextManager.getTestName(), testContextManager.getTestMode(), testContextManager.doNotRecordTest(), null, null, storage);
        if (testContextManager.getTestMode() != TestMode.LIVE && !testContextManager.doNotRecordTest() && !testContextManager.isTestProxyEnabled()) {
            Objects.requireNonNull(storage, "'recordedData' cannot be null.");
        }
    }

    public TestResourceNamer(TestContextManager testContextManager, Consumer<String> storeVariable, Supplier<String> getVariable) {
        this(testContextManager.getTestName(), testContextManager.getTestMode(), testContextManager.doNotRecordTest(), storeVariable, getVariable, null);
    }

    private TestResourceNamer(String name, TestMode testMode, boolean doNotRecord, Consumer<String> storeVariable, Supplier<String> getVariable, RecordedData storage) {
        super(name);
        this.allowedToReadRecordedValues = testMode == TestMode.PLAYBACK && !doNotRecord;
        boolean bl = this.allowedToRecordValues = testMode == TestMode.RECORD && !doNotRecord;
        if (this.allowedToReadRecordedValues || this.allowedToRecordValues) {
            if (storage != null) {
                this.storeVariable = storage::addVariable;
                this.getVariable = storage::removeVariable;
            } else {
                this.storeVariable = storeVariable;
                this.getVariable = getVariable;
            }
        } else {
            this.storeVariable = null;
            this.getVariable = null;
        }
    }

    @Override
    public String randomName(String prefix, int maxLen) {
        return this.getValue(readValue -> readValue, () -> super.randomName(prefix, maxLen));
    }

    @Override
    public String randomUuid() {
        return this.getValue(readValue -> readValue, () -> super.randomUuid());
    }

    public OffsetDateTime now() {
        return this.getValue(OffsetDateTime::parse, () -> OffsetDateTime.now(ZoneOffset.UTC));
    }

    public String recordValueFromConfig(String value) {
        return this.getValue(readValue -> readValue, () -> value);
    }

    private <T> T getValue(Function<String, T> readHandler, Supplier<T> valueSupplier) {
        if (this.allowedToReadRecordedValues) {
            return readHandler.apply(this.getVariable.get());
        }
        T value = valueSupplier.get();
        if (this.allowedToRecordValues) {
            this.storeVariable.accept(value.toString());
        }
        return value;
    }
}

