/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HttpBinJson
implements JsonSerializable<HttpBinJson> {
    private String url;
    private Map<String, List<String>> headers;
    private String data;

    public String url() {
        return this.url;
    }

    public void url(String url) {
        this.url = url;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String getHeaderValue(String name) {
        return this.headers == null ? null : (this.headers.containsKey(name) ? this.headers.get(name).get(0) : null);
    }

    public void headers(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String data() {
        return this.data;
    }

    public void data(String data) {
        this.data = data;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("url", this.url).writeMapField("headers", this.headers, (writer, list) -> writer.writeArray((Iterable)list, JsonWriter::writeString)).writeStringField("data", this.data).writeEndObject();
    }

    public static HttpBinJson fromJson(JsonReader jsonReader) throws IOException {
        return (HttpBinJson)jsonReader.readObject(reader -> {
            HttpBinJson headers = new HttpBinJson();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    headers.url = reader.getString();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    headers.headers = reader.readMap(listReader -> listReader.readArray(JsonReader::getString));
                    continue;
                }
                if ("data".equals(fieldName)) {
                    headers.data = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return headers;
        });
    }
}

