/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.models;

import com.azure.core.serializer.json.jackson.models.JacksonJsonElementUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.models.JsonElement;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.Objects;

public final class JacksonJsonArray
extends JsonElement {
    private final ArrayNode array;

    public JacksonJsonArray() {
        this(JsonNodeFactory.instance.arrayNode());
    }

    public JacksonJsonArray(ArrayNode array) {
        this.array = Objects.requireNonNull(array, "'array' cannot be null.");
    }

    public boolean isArray() {
        return true;
    }

    public JacksonJsonArray addElement(JsonNode node) {
        this.array.add(JacksonJsonArray.nullCheck(node));
        return this;
    }

    public JacksonJsonArray addElement(int index, JsonNode node) {
        this.array.insert(index, JacksonJsonArray.nullCheck(node));
        return this;
    }

    public JacksonJsonArray setElement(int index, JsonNode node) {
        this.array.set(index, JacksonJsonArray.nullCheck(node));
        return this;
    }

    public JsonNode getElement(int index) throws IndexOutOfBoundsException {
        return this.array.get(index);
    }

    public JsonNode removeElement(int index) throws IndexOutOfBoundsException {
        return this.array.remove(index);
    }

    public int size() {
        return this.array.size();
    }

    private static JsonNode nullCheck(JsonNode node) {
        return Objects.requireNonNull(node, "The JsonNode cannot be null. If null must be represented in JSON, use NullNode.");
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return JacksonJsonElementUtils.writeArrayNode(jsonWriter, this.array);
    }

    public static JacksonJsonArray fromJson(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.currentToken();
        if (token == null) {
            token = jsonReader.nextToken();
        }
        if (token != JsonToken.START_ARRAY) {
            throw new IllegalStateException("JsonReader is pointing to an invalid token for deserialization. Token was: " + token + ".");
        }
        return new JacksonJsonArray(JacksonJsonElementUtils.readArrayNode(jsonReader));
    }
}

