/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.models;

import com.azure.core.serializer.json.gson.models.GsonJsonElementUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.models.JsonElement;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.util.Objects;

public final class GsonJsonArray
extends JsonElement {
    private final JsonArray array;

    public GsonJsonArray() {
        this(new JsonArray());
    }

    public GsonJsonArray(JsonArray array) {
        this.array = Objects.requireNonNull(array, "'array' cannot be null.");
    }

    public boolean isArray() {
        return true;
    }

    public GsonJsonArray addElement(com.google.gson.JsonElement element) {
        this.array.add(GsonJsonArray.nullCheck(element));
        return this;
    }

    public GsonJsonArray addElement(int index, com.google.gson.JsonElement element) {
        this.array.asList().add(index, GsonJsonArray.nullCheck(element));
        return this;
    }

    public GsonJsonArray setElement(int index, com.google.gson.JsonElement element) {
        this.array.set(index, GsonJsonArray.nullCheck(element));
        return this;
    }

    public com.google.gson.JsonElement getElement(int index) throws IndexOutOfBoundsException {
        return this.array.get(index);
    }

    public com.google.gson.JsonElement removeElement(int index) throws IndexOutOfBoundsException {
        return this.array.remove(index);
    }

    public int size() {
        return this.array.size();
    }

    private static com.google.gson.JsonElement nullCheck(com.google.gson.JsonElement element) {
        return Objects.requireNonNull(element, "The JsonElement cannot be null. If null must be represented in JSON, use JsonNull.");
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return GsonJsonElementUtils.writeJsonArray(jsonWriter, this.array);
    }

    public static GsonJsonArray fromJson(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.currentToken();
        if (token == null) {
            token = jsonReader.nextToken();
        }
        if (token != JsonToken.START_ARRAY) {
            throw new IllegalStateException("JsonReader is pointing to an invalid token for deserialization. Token was: " + token + ".");
        }
        return new GsonJsonArray(GsonJsonElementUtils.readJsonArray(jsonReader));
    }
}

