/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson;

import com.azure.core.serializer.json.gson.implementation.AzureJsonUtils;
import com.azure.core.serializer.json.gson.implementation.JsonSerializableTypeAdapter;
import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class GsonJsonProvider
implements JsonProvider {
    public com.azure.json.JsonReader createReader(byte[] json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public com.azure.json.JsonReader createReader(String json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public com.azure.json.JsonReader createReader(InputStream json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public com.azure.json.JsonReader createReader(Reader json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public com.azure.json.JsonReader createReader(JsonReader reader, JsonOptions options) {
        return AzureJsonUtils.createReader(reader, options);
    }

    public JsonWriter createWriter(OutputStream json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createWriter(json, options);
    }

    public JsonWriter createWriter(Writer json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createWriter(json, options);
    }

    public JsonWriter createWriter(com.google.gson.stream.JsonWriter writer) {
        return AzureJsonUtils.createWriter(writer);
    }

    public static TypeAdapterFactory getJsonSerializableTypeAdapterFactory() {
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return JsonSerializable.class.isAssignableFrom(type.getRawType()) ? new JsonSerializableTypeAdapter(type.getRawType()) : null;
            }
        };
    }
}

