/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.implementation;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.serializer.json.gson.implementation.GsonJsonReader;
import com.azure.core.serializer.json.gson.implementation.GsonJsonWriter;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonSerializable;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;

public class JsonSerializableTypeAdapter
extends TypeAdapter<JsonSerializable<?>> {
    private static final ClientLogger LOGGER = new ClientLogger(JsonSerializableTypeAdapter.class);
    private final Class<? extends JsonSerializable<?>> jsonSerializableType;
    private final ReflectiveInvoker readJson;

    public JsonSerializableTypeAdapter(Class<? extends JsonSerializable<?>> jsonSerializableType) {
        this.jsonSerializableType = jsonSerializableType;
        try {
            this.readJson = ReflectionUtils.getMethodInvoker(jsonSerializableType, (Method)jsonSerializableType.getDeclaredMethod("fromJson", com.azure.json.JsonReader.class));
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public void write(JsonWriter out, JsonSerializable<?> value) throws IOException {
        new GsonJsonWriter(out).writeJson(value);
    }

    public JsonSerializable<?> read(JsonReader in) throws IOException {
        try {
            return this.jsonSerializableType.cast(this.readJson.invokeStatic(new Object[]{new GsonJsonReader(in, null, true)}));
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
    }
}

