/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriteContext;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Base64;
import java.util.Objects;

public final class GsonJsonWriter
extends JsonWriter {
    private static final ClientLogger LOGGER = new ClientLogger(GsonJsonWriter.class);
    private final com.google.gson.stream.JsonWriter writer;
    private JsonWriteContext context = JsonWriteContext.ROOT;

    public GsonJsonWriter(com.google.gson.stream.JsonWriter writer) {
        this.writer = Objects.requireNonNull(writer, "Cannot create a GSON-based instance of com.azure.json.JsonWriter with a null GSON JsonWriter");
    }

    public JsonWriteContext getWriteContext() {
        return this.context;
    }

    public void close() throws IOException {
        if (this.context != JsonWriteContext.COMPLETED) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Writing of the JSON object must be completed before the writer can be closed. Current writing state is '" + this.context.getWriteState() + "'."));
        }
        this.writer.flush();
        this.writer.close();
    }

    public JsonWriter flush() throws IOException {
        this.writer.flush();
        return this;
    }

    public JsonWriter writeStartObject() throws IOException {
        this.context.validateToken(JsonToken.START_OBJECT);
        this.writer.beginObject();
        this.context = this.context.updateContext(JsonToken.START_OBJECT);
        return this;
    }

    public JsonWriter writeEndObject() throws IOException {
        this.context.validateToken(JsonToken.END_OBJECT);
        this.writer.endObject();
        this.context = this.context.updateContext(JsonToken.END_OBJECT);
        return this;
    }

    public JsonWriter writeStartArray() throws IOException {
        this.context.validateToken(JsonToken.START_ARRAY);
        this.writer.beginArray();
        this.context = this.context.updateContext(JsonToken.START_ARRAY);
        return this;
    }

    public JsonWriter writeEndArray() throws IOException {
        this.context.validateToken(JsonToken.END_ARRAY);
        this.writer.endArray();
        this.context = this.context.updateContext(JsonToken.END_ARRAY);
        return this;
    }

    public JsonWriter writeFieldName(String fieldName) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        this.context.validateToken(JsonToken.FIELD_NAME);
        this.writer.name(fieldName);
        this.context = this.context.updateContext(JsonToken.FIELD_NAME);
        return this;
    }

    public JsonWriter writeBinary(byte[] value) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        this.writeBinaryInternal(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public JsonWriter writeBoolean(boolean value) throws IOException {
        this.context.validateToken(JsonToken.BOOLEAN);
        this.writer.value(value);
        this.context = this.context.updateContext(JsonToken.BOOLEAN);
        return this;
    }

    public JsonWriter writeDouble(double value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.writer.value(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeFloat(float value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.writer.value(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeInt(int value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.writer.value((long)value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeLong(long value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.writer.value(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeNull() throws IOException {
        this.context.validateToken(JsonToken.NULL);
        this.writer.nullValue();
        this.context = this.context.updateContext(JsonToken.NULL);
        return this;
    }

    public JsonWriter writeString(String value) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        this.writer.value(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public JsonWriter writeRawValue(String value) throws IOException {
        Objects.requireNonNull(value, "'value' cannot be null.");
        this.context.validateToken(JsonToken.STRING);
        this.writer.jsonValue(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    private void writeBinaryInternal(byte[] value) throws IOException {
        if (value == null) {
            this.writer.nullValue();
        } else {
            this.writer.value(Base64.getEncoder().encodeToString(value));
        }
    }
}

