/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.implementation;

import com.azure.core.serializer.json.gson.implementation.GsonJsonReader;
import com.azure.core.serializer.json.gson.implementation.GsonJsonWriter;
import com.azure.json.JsonOptions;
import com.azure.json.JsonWriter;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class AzureJsonUtils {
    public static com.azure.json.JsonReader createReader(byte[] json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new GsonJsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(json), StandardCharsets.UTF_8), json, null, true, options);
    }

    public static com.azure.json.JsonReader createReader(String json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new GsonJsonReader(new StringReader(json), null, json, true, options);
    }

    public static com.azure.json.JsonReader createReader(InputStream json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new GsonJsonReader(new InputStreamReader(json, StandardCharsets.UTF_8), null, null, false, options);
    }

    public static com.azure.json.JsonReader createReader(Reader json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new GsonJsonReader(json, null, null, false, options);
    }

    public static com.azure.json.JsonReader createReader(JsonReader reader, JsonOptions options) {
        return new GsonJsonReader(reader, options, false);
    }

    public static JsonWriter createWriter(OutputStream json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON target cannot be null when creating a JsonWriter.");
        return new GsonJsonWriter(AzureJsonUtils.createGsonWriter(new OutputStreamWriter(json, StandardCharsets.UTF_8), options));
    }

    public static JsonWriter createWriter(Writer json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON target cannot be null when creating a JsonWriter.");
        return new GsonJsonWriter(AzureJsonUtils.createGsonWriter(json, options));
    }

    private static com.google.gson.stream.JsonWriter createGsonWriter(Writer writer, JsonOptions options) {
        boolean lenient = options == null || options.isNonNumericNumbersSupported();
        com.google.gson.stream.JsonWriter gsonWriter = new com.google.gson.stream.JsonWriter(writer);
        gsonWriter.setLenient(lenient);
        return gsonWriter;
    }

    public static JsonWriter createWriter(com.google.gson.stream.JsonWriter writer) {
        return new GsonJsonWriter(writer);
    }

    private AzureJsonUtils() {
    }
}

