/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.MemberNameConverter;
import com.azure.core.util.serializer.TypeReference;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public final class GsonJsonSerializer
implements JsonSerializer,
MemberNameConverter {
    private static final ClientLogger LOGGER = new ClientLogger(GsonJsonSerializer.class);
    private final Gson gson;

    GsonJsonSerializer(Gson gson) {
        this.gson = gson;
    }

    public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
        if (stream == null) {
            return null;
        }
        return (T)this.gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), typeReference.getJavaType());
    }

    public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserialize(stream, typeReference));
    }

    public void serialize(OutputStream stream, Object value) {
        OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        this.gson.toJson(value, (Appendable)writer);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public Mono<byte[]> serializeToBytesAsync(Object value) {
        return Mono.fromCallable(() -> this.serializeToBytes(value));
    }

    public Mono<Void> serializeAsync(OutputStream stream, Object value) {
        return Mono.fromRunnable(() -> this.serialize(stream, value));
    }

    public String convertMemberName(Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        if (member instanceof Field) {
            Field f = (Field)member;
            if (f.isAnnotationPresent(SerializedName.class)) {
                return f.getDeclaredAnnotation(SerializedName.class).value();
            }
            return member.getName();
        }
        return null;
    }
}

