/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx.implementation;

import com.azure.core.http.HttpResponse;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class VertxRequestWriteSubscriber
implements Subscriber<ByteBuffer> {
    private static final ClientLogger LOGGER = new ClientLogger(VertxRequestWriteSubscriber.class);
    private final Function<Buffer, Future<Void>> writeHandler;
    private final Supplier<Boolean> isWriteQueueFull;
    private final BiConsumer<Long, Throwable> reset;
    private final Supplier<Future<Void>> end;
    private final Promise<HttpResponse> promise;
    private final ProgressReporter progressReporter;
    private final ContextView contextView;
    private volatile Subscription subscription;
    private volatile State state = State.UNINITIALIZED;
    private volatile Throwable error;

    public VertxRequestWriteSubscriber(Consumer<Handler<Throwable>> exceptionHandlerUpdater, Consumer<Handler<Void>> drainHandlerUpdater, Function<Buffer, Future<Void>> writeHandler, Supplier<Boolean> isWriteQueueFull, BiConsumer<Long, Throwable> reset, Supplier<Future<Void>> end, Promise<HttpResponse> promise, ProgressReporter progressReporter, ContextView contextView) {
        exceptionHandlerUpdater.accept((Handler<Throwable>)((Handler)this::onError));
        drainHandlerUpdater.accept((Handler<Void>)((Handler)ignored -> this.requestNext()));
        this.writeHandler = writeHandler;
        this.isWriteQueueFull = isWriteQueueFull;
        this.reset = reset;
        this.end = end;
        this.promise = promise;
        this.progressReporter = progressReporter;
        this.contextView = contextView;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
            this.subscription = s;
            s.request(1L);
        }
    }

    public void onNext(ByteBuffer bytes) {
        try {
            if (this.state == State.WRITING) {
                this.onErrorInternal(new IllegalStateException("Received onNext while processing another write operation."));
            } else {
                this.state = State.WRITING;
                this.write(bytes);
            }
        }
        catch (Exception ex) {
            this.onErrorInternal(ex);
        }
    }

    private void write(ByteBuffer bytes) {
        int remaining = bytes.remaining();
        this.writeHandler.apply(Buffer.buffer((byte[])FluxUtil.byteBufferToArray((ByteBuffer)bytes))).onComplete(result -> {
            State state = this.state;
            if (state == State.WRITING) {
                this.state = State.UNINITIALIZED;
            }
            if (result.succeeded()) {
                if (state == State.WRITING) {
                    if (remaining > 0 && this.progressReporter != null) {
                        this.progressReporter.reportProgress((long)remaining);
                    }
                    if (!this.isWriteQueueFull.get().booleanValue()) {
                        this.requestNext();
                    }
                } else if (state == State.COMPLETE) {
                    this.endRequest(remaining);
                } else if (state == State.ERROR) {
                    this.resetRequest(this.error);
                }
            } else {
                this.state = State.ERROR;
                if (this.error != null) {
                    result.cause().addSuppressed(this.error);
                }
                this.resetRequest(result.cause());
            }
        });
    }

    private void requestNext() {
        if (this.state == State.UNINITIALIZED) {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable throwable) {
        this.onErrorInternal(throwable);
    }

    private void onErrorInternal(Throwable throwable) {
        State state = this.state;
        if (state.code >= 2) {
            Operators.onErrorDropped((Throwable)throwable, (Context)Context.of((ContextView)this.contextView));
            LOGGER.atInfo().log(() -> "VertxRequestWriteSubscriber dropped an exception as it already reached a completion state.", throwable);
        }
        this.state = State.ERROR;
        if (state != State.WRITING) {
            this.resetRequest(throwable);
        } else if (this.error != null) {
            this.error.addSuppressed(throwable);
        } else {
            this.error = throwable;
        }
    }

    private void resetRequest(Throwable throwable) {
        this.subscription.cancel();
        if (!this.promise.tryFail(throwable)) {
            Throwable cause = this.promise.future().cause();
            if (cause != null) {
                cause.addSuppressed(throwable);
                LOGGER.atInfo().log(() -> "VertxRequestWriteSubscriber added an exception as a suppressed exception as the Promise already failed.", throwable);
            } else {
                Operators.onErrorDropped((Throwable)LOGGER.logThrowableAsError(throwable), (Context)Context.of((ContextView)this.contextView));
                LOGGER.atInfo().log(() -> "VertxRequestWriteSubscriber dropped an exception as the Promise already completed successfully.", throwable);
            }
        }
        this.reset.accept(0L, throwable);
    }

    public void onComplete() {
        State state = this.state;
        if (state.code >= 2) {
            return;
        }
        this.state = State.COMPLETE;
        if (state != State.WRITING) {
            this.endRequest(0);
        }
    }

    private void endRequest(int finishingWriteSize) {
        if (finishingWriteSize > 0 && this.progressReporter != null) {
            this.progressReporter.reportProgress((long)finishingWriteSize);
        }
        this.end.get().onFailure(arg_0 -> this.promise.fail(arg_0));
    }

    private static enum State {
        UNINITIALIZED(0),
        WRITING(1),
        COMPLETE(2),
        ERROR(3);

        private final int code;

        private State(int code) {
            this.code = code;
        }
    }
}

