/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.jdk.httpclient.implementation.InputStreamWithReadTimeout;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpResponseBase;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpUtils;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class JdkHttpResponseSync
extends JdkHttpResponseBase {
    private static final ClientLogger LOGGER = new ClientLogger(JdkHttpResponseSync.class);
    private BinaryData binaryData = null;
    public static final int STREAM_READ_SIZE = 8192;
    private final InputStream bodyStream;
    private byte[] bodyBytes;
    private volatile int disposed = 0;
    private static final AtomicIntegerFieldUpdater<JdkHttpResponseSync> DISPOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(JdkHttpResponseSync.class, "disposed");

    public JdkHttpResponseSync(HttpRequest request, int statusCode, HttpHeaders headers, byte[] bytes) {
        super(request, statusCode, headers);
        this.bodyStream = null;
        this.bodyBytes = bytes;
    }

    public JdkHttpResponseSync(HttpRequest request, java.net.http.HttpResponse<InputStream> streamResponse, Duration readTimeout) {
        super(request, streamResponse.statusCode(), JdkHttpUtils.fromJdkHttpHeaders(streamResponse.headers()));
        this.bodyStream = new InputStreamWithReadTimeout(streamResponse.body(), readTimeout);
        this.bodyBytes = null;
    }

    public Flux<ByteBuffer> getBody() {
        if (this.bodyBytes != null) {
            return Mono.fromSupplier(() -> ByteBuffer.wrap(this.bodyBytes)).flux();
        }
        return Flux.using(() -> this, ignored -> FluxUtil.toFluxByteBuffer((InputStream)this.bodyStream), JdkHttpResponseSync::close);
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        if (this.bodyBytes != null) {
            return Mono.just((Object)this.bodyBytes);
        }
        return super.getBodyAsByteArray();
    }

    public BinaryData getBodyAsBinaryData() {
        if (this.bodyBytes != null) {
            return BinaryData.fromBytes((byte[])this.bodyBytes);
        }
        return this.getBinaryData();
    }

    public void writeBodyTo(WritableByteChannel channel) throws IOException {
        if (this.bodyBytes != null) {
            channel.write(ByteBuffer.wrap(this.bodyBytes));
        } else {
            int nRead;
            byte[] data = new byte[8192];
            while ((nRead = this.bodyStream.read(data, 0, data.length)) != -1) {
                channel.write(ByteBuffer.wrap(data, 0, nRead));
            }
            this.close();
        }
    }

    public void close() {
        if (this.bodyStream != null && DISPOSED_UPDATER.compareAndSet(this, 0, 1)) {
            try {
                this.bodyStream.close();
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
            }
        }
    }

    public HttpResponse buffer() {
        if (this.bodyBytes == null) {
            this.bodyBytes = this.getBytes();
            this.close();
        }
        return this;
    }

    private byte[] getBytes() {
        try {
            int nRead;
            ByteArrayOutputStream dataOutputBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((nRead = this.bodyStream.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArray();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    private BinaryData getBinaryData() {
        if (this.binaryData == null) {
            this.binaryData = BinaryData.fromStream((InputStream)this.bodyStream);
        }
        return this.binaryData;
    }
}

