/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import java.util.Objects;

public final class GeoBoundingBox {
    private final double west;
    private final double south;
    private final double east;
    private final double north;
    private final Double minAltitude;
    private final Double maxAltitude;

    public GeoBoundingBox(double west, double south, double east, double north) {
        this(west, south, east, north, null, null);
    }

    public GeoBoundingBox(double west, double south, double east, double north, Double minAltitude, Double maxAltitude) {
        this.west = west;
        this.south = south;
        this.east = east;
        this.north = north;
        this.minAltitude = minAltitude;
        this.maxAltitude = maxAltitude;
    }

    public double getWest() {
        return this.west;
    }

    public double getSouth() {
        return this.south;
    }

    public double getEast() {
        return this.east;
    }

    public double getNorth() {
        return this.north;
    }

    public Double getMinAltitude() {
        return this.minAltitude;
    }

    public Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public int hashCode() {
        return Objects.hash(this.west, this.south, this.east, this.north, this.minAltitude, this.maxAltitude);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoBoundingBox)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoBoundingBox other = (GeoBoundingBox)obj;
        return this.west == other.west && this.south == other.south && this.east == other.east && this.north == other.north && Objects.equals(this.minAltitude, other.minAltitude) && Objects.equals(this.maxAltitude, other.maxAltitude);
    }
}

