/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoLineCollection;
import com.azure.core.experimental.geojson.GeoPointCollection;
import com.azure.core.experimental.geojson.GeoPolygon;
import com.azure.core.experimental.geojson.GeoPolygonCollection;
import com.azure.core.util.logging.ClientLogger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class GeoArray<T>
extends AbstractList<T> {
    private final ClientLogger logger = new ClientLogger(GeoArray.class);
    private final Object container;

    GeoArray(Object container) {
        this.container = container;
    }

    @Override
    public T get(int index) {
        if (this.container instanceof List) {
            return (T)((List)this.container).get(index);
        }
        if (this.container instanceof GeoPointCollection) {
            return (T)((GeoPointCollection)this.container).getPoints().get(index).getCoordinates();
        }
        if (this.container instanceof GeoLineCollection) {
            return (T)((GeoLineCollection)this.container).getLines().get(index).getCoordinates();
        }
        if (this.container instanceof GeoPolygon) {
            return (T)((GeoPolygon)this.container).getRings().get(index).getCoordinates();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return (T)((GeoPolygonCollection)this.container).getPolygons().get(index).getCoordinates();
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException());
    }

    @Override
    public int size() {
        if (this.container instanceof List) {
            return ((List)this.container).size();
        }
        if (this.container instanceof GeoPointCollection) {
            return ((GeoPointCollection)this.container).getPoints().size();
        }
        if (this.container instanceof GeoLineCollection) {
            return ((GeoLineCollection)this.container).getLines().size();
        }
        if (this.container instanceof GeoPolygon) {
            return ((GeoPolygon)this.container).getRings().size();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return ((GeoPolygonCollection)this.container).getPolygons().size();
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException());
    }

    @Override
    public Iterator<T> iterator() {
        return new GeoArrayIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new GeoArrayListIterator(index);
    }

    @Override
    public boolean add(T t) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public void add(int index, T element) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public T set(int index, T element) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public T remove(int index) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public void clear() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public boolean remove(Object o) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public void sort(Comparator<? super T> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray does not support sub lists."));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoArray)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        GeoArray other = (GeoArray)o;
        return Objects.equals(this.container, other.container);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.container);
    }

    private final class GeoArrayListIterator
    extends GeoArrayIterator
    implements ListIterator<T> {
        private GeoArrayListIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            try {
                int i = this.cursor - 1;
                Object value = GeoArray.this.get(i);
                this.cursor = i;
                return value;
            }
            catch (IndexOutOfBoundsException ex) {
                throw GeoArray.this.logger.logExceptionAsError((RuntimeException)new NoSuchElementException());
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw GeoArray.this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
        }

        @Override
        public void set(T t) {
            throw GeoArray.this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
        }

        @Override
        public void add(T t) {
            throw GeoArray.this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray cannot be mutated."));
        }
    }

    private class GeoArrayIterator
    implements Iterator<T> {
        transient int cursor;

        private GeoArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != GeoArray.this.size();
        }

        @Override
        public T next() {
            try {
                int i = this.cursor;
                Object value = GeoArray.this.get(i);
                this.cursor = i + 1;
                return value;
            }
            catch (IndexOutOfBoundsException ex) {
                throw GeoArray.this.logger.logExceptionAsError((RuntimeException)new NoSuchElementException());
            }
        }
    }
}

