/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.models;

import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PollResult
implements JsonSerializable<PollResult> {
    private final String operationId;
    private ResponseError error;

    private PollResult(String operationId) {
        this.operationId = operationId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ResponseError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("id", this.operationId).writeJsonField("error", (JsonSerializable)this.error).writeEndObject();
    }

    public static PollResult fromJson(JsonReader jsonReader) throws IOException {
        return (PollResult)jsonReader.readObject(reader -> {
            String operationId = null;
            ResponseError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    operationId = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            PollResult pollResult = new PollResult(operationId);
            pollResult.error = error;
            return pollResult;
        });
    }
}

