/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.PolygonGeometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MultiPolygonGeometry
extends Geometry {
    private final List<PolygonGeometry> polygons;

    public MultiPolygonGeometry(List<PolygonGeometry> polygons) {
        this(polygons, null, null);
    }

    public MultiPolygonGeometry(List<PolygonGeometry> polygons, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(polygons, "'polygons' cannot be null.");
        this.polygons = Collections.unmodifiableList(new ArrayList<PolygonGeometry>(polygons));
    }

    public List<PolygonGeometry> getPolygons() {
        return this.polygons;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.polygons, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MultiPolygonGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MultiPolygonGeometry other = (MultiPolygonGeometry)obj;
        return super.equals(obj) && Objects.equals(this.polygons, other.polygons);
    }
}

