/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.LineGeometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MultiLineGeometry
extends Geometry {
    private final List<LineGeometry> lines;

    public MultiLineGeometry(List<LineGeometry> lines) {
        this(lines, null, null);
    }

    public MultiLineGeometry(List<LineGeometry> lines, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(lines, "'lines' cannot be null.");
        this.lines = Collections.unmodifiableList(new ArrayList<LineGeometry>(lines));
    }

    public List<LineGeometry> getLines() {
        return this.lines;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MultiLineGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MultiLineGeometry other = (MultiLineGeometry)obj;
        return super.equals(obj) && Objects.equals(this.lines, other.lines);
    }
}

