/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.CollectionGeometry;
import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.GeometryPosition;
import com.azure.core.experimental.spatial.LineGeometry;
import com.azure.core.experimental.spatial.MultiLineGeometry;
import com.azure.core.experimental.spatial.MultiPointGeometry;
import com.azure.core.experimental.spatial.MultiPolygonGeometry;
import com.azure.core.experimental.spatial.PointGeometry;
import com.azure.core.experimental.spatial.PolygonGeometry;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class GeometrySerializer
extends JsonSerializer<Geometry> {
    private static final ClientLogger LOGGER = new ClientLogger(GeometrySerializer.class);
    static final SimpleModule MODULE = new SimpleModule();

    GeometrySerializer() {
    }

    public void serialize(Geometry value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        GeometrySerializer.write(value, gen);
    }

    private static void write(Geometry value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        if (value instanceof PointGeometry) {
            GeometrySerializer.writeType("Point", gen);
            gen.writeFieldName("coordinates");
            GeometrySerializer.writePosition(((PointGeometry)value).getPosition(), gen);
        } else if (value instanceof LineGeometry) {
            GeometrySerializer.writeType("LineString", gen);
            gen.writeFieldName("coordinates");
            GeometrySerializer.writePositions(((LineGeometry)value).getPositions(), gen);
        } else if (value instanceof PolygonGeometry) {
            GeometrySerializer.writeType("Polygon", gen);
            gen.writeArrayFieldStart("coordinates");
            for (LineGeometry ring : ((PolygonGeometry)value).getRings()) {
                GeometrySerializer.writePositions(ring.getPositions(), gen);
            }
            gen.writeEndArray();
        } else if (value instanceof MultiPointGeometry) {
            GeometrySerializer.writeType("MultiPoint", gen);
            gen.writeArrayFieldStart("coordinates");
            for (PointGeometry point : ((MultiPointGeometry)value).getPoints()) {
                GeometrySerializer.writePosition(point.getPosition(), gen);
            }
            gen.writeEndArray();
        } else if (value instanceof MultiLineGeometry) {
            GeometrySerializer.writeType("MultiLineString", gen);
            gen.writeArrayFieldStart("coordinates");
            for (LineGeometry line : ((MultiLineGeometry)value).getLines()) {
                GeometrySerializer.writePositions(line.getPositions(), gen);
            }
            gen.writeEndArray();
        } else if (value instanceof MultiPolygonGeometry) {
            GeometrySerializer.writeType("MultiPolygon", gen);
            gen.writeArrayFieldStart("coordinates");
            for (PolygonGeometry polygon : ((MultiPolygonGeometry)value).getPolygons()) {
                gen.writeStartArray();
                for (LineGeometry ring : polygon.getRings()) {
                    GeometrySerializer.writePositions(ring.getPositions(), gen);
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
        } else if (value instanceof CollectionGeometry) {
            GeometrySerializer.writeType("GeometryCollection", gen);
            gen.writeArrayFieldStart("geometries");
            for (Geometry geometry : ((CollectionGeometry)value).getGeometries()) {
                GeometrySerializer.write(geometry, gen);
            }
            gen.writeEndArray();
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Geometry type '%s' isn't supported.", value.getClass().getName())));
        }
        GeometrySerializer.writeBoundingBox(value.getBoundingBox(), gen);
        GeometrySerializer.writeAdditionalProperties(value.getProperties(), gen);
        gen.writeEndObject();
    }

    private static void writePositions(List<GeometryPosition> positions, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (GeometryPosition position : positions) {
            GeometrySerializer.writePosition(position, gen);
        }
        gen.writeEndArray();
    }

    private static void writePosition(GeometryPosition position, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        gen.writeNumber(position.getLongitude());
        gen.writeNumber(position.getLatitude());
        Double altitude = position.getAltitude();
        if (altitude != null) {
            gen.writeNumber(altitude.doubleValue());
        }
        gen.writeEndArray();
    }

    private static void writeType(String type, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", type);
    }

    private static void writeBoundingBox(GeometryBoundingBox boundingBox, JsonGenerator gen) throws IOException {
        if (boundingBox == null) {
            return;
        }
        gen.writeArrayFieldStart("bbox");
        gen.writeNumber(boundingBox.getWest());
        gen.writeNumber(boundingBox.getSouth());
        Double minAltitude = boundingBox.getMinAltitude();
        if (minAltitude != null) {
            gen.writeNumber(minAltitude.doubleValue());
        }
        gen.writeNumber(boundingBox.getEast());
        gen.writeNumber(boundingBox.getNorth());
        Double maxAltitude = boundingBox.getMaxAltitude();
        if (maxAltitude != null) {
            gen.writeNumber(maxAltitude.doubleValue());
        }
        gen.writeEndArray();
    }

    private static void writeAdditionalProperties(Map<String, Object> properties, JsonGenerator gen) throws IOException {
        if (CoreUtils.isNullOrEmpty(properties)) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            gen.writeFieldName(property.getKey());
            gen.writeObject(property.getValue());
        }
    }

    static {
        MODULE.addSerializer(Geometry.class, (JsonSerializer)new GeometrySerializer());
    }
}

