/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import java.util.Objects;

public final class GeometryPosition {
    private final double longitude;
    private final double latitude;
    private final Double altitude;

    public GeometryPosition(double longitude, double latitude) {
        this(longitude, latitude, null);
    }

    public GeometryPosition(double longitude, double latitude, Double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude, this.altitude);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeometryPosition)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        GeometryPosition other = (GeometryPosition)obj;
        return this.longitude == other.longitude && this.latitude == other.latitude && Objects.equals(this.altitude, other.altitude);
    }
}

