/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.CollectionGeometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.LineGeometry;
import com.azure.core.experimental.spatial.MultiLineGeometry;
import com.azure.core.experimental.spatial.MultiPointGeometry;
import com.azure.core.experimental.spatial.MultiPolygonGeometry;
import com.azure.core.experimental.spatial.PointGeometry;
import com.azure.core.experimental.spatial.PolygonGeometry;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonSubTypes(value={@JsonSubTypes.Type(value=PointGeometry.class), @JsonSubTypes.Type(value=LineGeometry.class), @JsonSubTypes.Type(value=PolygonGeometry.class), @JsonSubTypes.Type(value=MultiPointGeometry.class), @JsonSubTypes.Type(value=MultiLineGeometry.class), @JsonSubTypes.Type(value=MultiPolygonGeometry.class), @JsonSubTypes.Type(value=CollectionGeometry.class)})
public abstract class Geometry {
    private final GeometryBoundingBox boundingBox;
    private final Map<String, Object> properties;

    protected Geometry(GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        this.boundingBox = boundingBox;
        this.properties = properties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public GeometryBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBox, this.properties);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Geometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Geometry other = (Geometry)obj;
        return Objects.equals(this.boundingBox, other.boundingBox) && Objects.equals(this.properties, other.properties);
    }
}

