/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CollectionGeometry
extends Geometry {
    private final List<Geometry> geometries;

    public CollectionGeometry(List<Geometry> geometries) {
        this(geometries, null, null);
    }

    public CollectionGeometry(List<Geometry> geometries, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(geometries, "'geometries' cannot be null.");
        this.geometries = Collections.unmodifiableList(new ArrayList<Geometry>(geometries));
    }

    public List<Geometry> getGeometries() {
        return this.geometries;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.geometries, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CollectionGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CollectionGeometry other = (CollectionGeometry)obj;
        return super.equals(other) && Objects.equals(this.geometries, other.geometries);
    }
}

