/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.jsonpatch;

import com.azure.core.experimental.jsonpatch.JsonPatchOperation;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Optional;

public class JsonPatchOperationSerializer
extends JsonSerializer<JsonPatchOperation> {
    private static final Module MODULE = new SimpleModule().addSerializer(JsonPatchOperation.class, (JsonSerializer)new JsonPatchOperationSerializer());

    public static Module getModule() {
        return MODULE;
    }

    public void serialize(JsonPatchOperation value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("op", value.getOperationKind().toString());
        String from = value.getFrom();
        if (from != null) {
            gen.writeStringField("from", from);
        }
        gen.writeStringField("path", value.getPath());
        Optional<String> optionalValue = value.getOptionalValue();
        if (optionalValue != null) {
            if (optionalValue.isPresent()) {
                gen.writeFieldName("value");
                gen.writeRawValue(optionalValue.get());
            } else {
                gen.writeNullField("value");
            }
        }
        gen.writeEndObject();
    }
}

