/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.jsonpatch;

import com.azure.core.experimental.jsonpatch.JsonPatchOperationKind;
import java.util.Objects;
import java.util.Optional;

public final class JsonPatchOperation {
    private final JsonPatchOperationKind operationKind;
    private final String from;
    private final String path;
    private final Optional<String> optionalValue;

    public JsonPatchOperation(JsonPatchOperationKind operationKind, String from, String path, Optional<String> optionalValue) {
        this.operationKind = operationKind;
        this.from = from;
        this.path = path;
        this.optionalValue = optionalValue;
    }

    public JsonPatchOperationKind getOperationKind() {
        return this.operationKind;
    }

    public String getFrom() {
        return this.from;
    }

    public String getPath() {
        return this.path;
    }

    public Optional<String> getOptionalValue() {
        return this.optionalValue;
    }

    public int hashCode() {
        return Objects.hash(this.operationKind.toString(), this.from, this.path, this.optionalValue == null ? null : this.optionalValue.get());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonPatchOperation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JsonPatchOperation other = (JsonPatchOperation)obj;
        return Objects.equals((Object)this.operationKind, (Object)other.operationKind) && Objects.equals(this.from, other.from) && Objects.equals(this.path, other.path) && Objects.equals(this.optionalValue, other.optionalValue);
    }

    public String toString() {
        return this.buildString(new StringBuilder()).toString();
    }

    StringBuilder buildString(StringBuilder builder) {
        builder.append("{\"op\":\"").append(this.operationKind.toString()).append("\"");
        if (this.from != null) {
            builder.append(",\"from\":\"").append(this.from).append("\"");
        }
        builder.append(",\"path\":\"").append(this.path).append("\"");
        if (this.optionalValue != null) {
            builder.append(",\"value\":");
            if (this.optionalValue.isPresent()) {
                builder.append(this.optionalValue.get());
            } else {
                builder.append("null");
            }
        }
        return builder.append("}");
    }
}

