/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.jsonpatch;

import com.azure.core.experimental.jsonpatch.JsonPatchDocument;
import com.azure.core.experimental.jsonpatch.JsonPatchOperation;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class JsonPatchDocumentSerializer
extends JsonSerializer<JsonPatchDocument> {
    private static final Module MODULE = new SimpleModule().addSerializer(JsonPatchDocument.class, (JsonSerializer)new JsonPatchDocumentSerializer());

    public static Module getModule() {
        return MODULE;
    }

    public void serialize(JsonPatchDocument value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (CoreUtils.isNullOrEmpty(value.getJsonPatchOperations())) {
            return;
        }
        gen.writeStartArray(value.getJsonPatchOperations().size());
        for (JsonPatchOperation operation : value.getJsonPatchOperations()) {
            gen.writeObject((Object)operation);
        }
        gen.writeEndArray();
    }
}

