/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.jsonpatch;

import com.azure.core.experimental.jsonpatch.JsonPatchOperation;
import com.azure.core.experimental.jsonpatch.JsonPatchOperationKind;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonPatchDocument {
    private static final ObjectMapper MAPPER = ((JacksonAdapter)JacksonAdapter.createDefaultSerializerAdapter()).serializer();
    private final ClientLogger logger = new ClientLogger(JsonPatchDocument.class);
    private final List<JsonPatchOperation> operations = new ArrayList<JsonPatchOperation>();
    private final JsonSerializer serializer;

    public JsonPatchDocument() {
        this(null);
    }

    public JsonPatchDocument(JsonSerializer serializer) {
        this.serializer = serializer;
    }

    public List<JsonPatchOperation> getJsonPatchOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public JsonPatchDocument appendAdd(String path, Object value) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.ADD, null, path, this.serializeValue(value));
    }

    public JsonPatchDocument appendReplace(String path, Object value) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REPLACE, null, path, this.serializeValue(value));
    }

    public JsonPatchDocument appendCopy(String from, String path) {
        Objects.requireNonNull(from, "'from' cannot be null.");
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.COPY, from, path, null);
    }

    public JsonPatchDocument appendMove(String from, String path) {
        Objects.requireNonNull(from, "'from' cannot be null.");
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.MOVE, from, path, null);
    }

    public JsonPatchDocument appendRemove(String path) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REMOVE, null, path, null);
    }

    public JsonPatchDocument appendTest(String path, Object value) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.TEST, null, path, this.serializeValue(value));
    }

    private Optional<String> serializeValue(Object value) {
        String rawValue;
        if (value == null) {
            return Optional.empty();
        }
        try {
            if (this.serializer == null) {
                rawValue = MAPPER.writeValueAsString(value);
            } else {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.serializer.serialize((OutputStream)outputStream, value);
                rawValue = outputStream.toString("UTF-8");
            }
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return Optional.of(rawValue);
    }

    private JsonPatchDocument appendOperation(JsonPatchOperationKind operationKind, String from, String path, Optional<String> optionalValue) {
        this.operations.add(new JsonPatchOperation(operationKind, from, path, optionalValue));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.operations.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            this.operations.get(i).buildString(builder);
        }
        return builder.append("]").toString();
    }
}

