/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.LineGeometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class PolygonGeometry
extends Geometry {
    private final List<LineGeometry> rings;

    public PolygonGeometry(List<LineGeometry> rings) {
        this(rings, null, null);
    }

    public PolygonGeometry(List<LineGeometry> rings, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(rings, "'rings' cannot be null.");
        this.rings = Collections.unmodifiableList(new ArrayList<LineGeometry>(rings));
    }

    public List<LineGeometry> getRings() {
        return this.rings;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rings, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PolygonGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PolygonGeometry other = (PolygonGeometry)obj;
        return super.equals(obj) && Objects.equals(this.rings, other.rings);
    }
}

