/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.GeometryPosition;
import java.util.Map;
import java.util.Objects;

public final class PointGeometry
extends Geometry {
    private final GeometryPosition position;

    public PointGeometry(GeometryPosition position) {
        this(position, null, null);
    }

    public PointGeometry(GeometryPosition position, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(position, "'position' cannot be null.");
        this.position = position;
    }

    public GeometryPosition getPosition() {
        return this.position;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.position, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PointGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PointGeometry other = (PointGeometry)obj;
        return super.equals(obj) && Objects.equals(this.position, other.position);
    }
}

