/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.PointGeometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MultiPointGeometry
extends Geometry {
    private final List<PointGeometry> points;

    public MultiPointGeometry(List<PointGeometry> points) {
        this(points, null, null);
    }

    public MultiPointGeometry(List<PointGeometry> points, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(points, "'points' cannot be null.");
        this.points = Collections.unmodifiableList(new ArrayList<PointGeometry>(points));
    }

    public List<PointGeometry> getPoints() {
        return this.points;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.points, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MultiPointGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MultiPointGeometry other = (MultiPointGeometry)obj;
        return super.equals(obj) && Objects.equals(this.points, other.points);
    }
}

