/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.GeometryPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LineGeometry
extends Geometry {
    private final List<GeometryPosition> positions;

    public LineGeometry(List<GeometryPosition> positions) {
        this(positions, null, null);
    }

    public LineGeometry(List<GeometryPosition> positions, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        super(boundingBox, properties);
        Objects.requireNonNull(positions, "'positions' cannot be null.");
        this.positions = Collections.unmodifiableList(new ArrayList<GeometryPosition>(positions));
    }

    public List<GeometryPosition> getPositions() {
        return this.positions;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.positions, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LineGeometry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LineGeometry other = (LineGeometry)obj;
        return super.equals(other) && Objects.equals(this.positions, other.positions);
    }
}

