/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.spatial;

import com.azure.core.experimental.spatial.CollectionGeometry;
import com.azure.core.experimental.spatial.Geometry;
import com.azure.core.experimental.spatial.GeometryBoundingBox;
import com.azure.core.experimental.spatial.GeometryPosition;
import com.azure.core.experimental.spatial.LineGeometry;
import com.azure.core.experimental.spatial.MultiLineGeometry;
import com.azure.core.experimental.spatial.MultiPointGeometry;
import com.azure.core.experimental.spatial.MultiPolygonGeometry;
import com.azure.core.experimental.spatial.PointGeometry;
import com.azure.core.experimental.spatial.PolygonGeometry;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class GeometryDeserializer
extends JsonDeserializer<Geometry> {
    private static final ClientLogger LOGGER = new ClientLogger(GeometryDeserializer.class);
    static final String POINT_TYPE = "Point";
    static final String LINE_STRING_TYPE = "LineString";
    static final String MULTI_POINT_TYPE = "MultiPoint";
    static final String POLYGON_TYPE = "Polygon";
    static final String MULTI_LINE_STRING_TYPE = "MultiLineString";
    static final String MULTI_POLYGON_TYPE = "MultiPolygon";
    static final String GEOMETRY_COLLECTION_TYPE = "GeometryCollection";
    static final String TYPE_PROPERTY = "type";
    static final String GEOMETRIES_PROPERTY = "geometries";
    static final String COORDINATES_PROPERTY = "coordinates";
    static final String BOUNDING_BOX_PROPERTY = "bbox";
    static final SimpleModule MODULE = new SimpleModule().addDeserializer(Geometry.class, (JsonDeserializer)new GeometryDeserializer()).addDeserializer(PointGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(PointGeometry.class)).addDeserializer(LineGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(LineGeometry.class)).addDeserializer(PolygonGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(PolygonGeometry.class)).addDeserializer(MultiPointGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(MultiPointGeometry.class)).addDeserializer(MultiLineGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(MultiLineGeometry.class)).addDeserializer(MultiPolygonGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(MultiPolygonGeometry.class)).addDeserializer(CollectionGeometry.class, GeometryDeserializer.geometrySubclassDeserializer(CollectionGeometry.class));

    GeometryDeserializer() {
    }

    public Geometry deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return GeometryDeserializer.read(ctxt.readTree(p));
    }

    private static Geometry read(JsonNode node) {
        String type = GeometryDeserializer.getRequiredProperty(node, TYPE_PROPERTY).asText();
        if (GEOMETRY_COLLECTION_TYPE.equalsIgnoreCase(type)) {
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            for (JsonNode geometryNode : GeometryDeserializer.getRequiredProperty(node, GEOMETRIES_PROPERTY)) {
                geometries.add(GeometryDeserializer.read(geometryNode));
            }
            return new CollectionGeometry(geometries, GeometryDeserializer.readBoundingBox(node), GeometryDeserializer.readProperties(node, GEOMETRIES_PROPERTY));
        }
        JsonNode coordinates = GeometryDeserializer.getRequiredProperty(node, COORDINATES_PROPERTY);
        GeometryBoundingBox boundingBox = GeometryDeserializer.readBoundingBox(node);
        Map<String, Object> properties = GeometryDeserializer.readProperties(node);
        switch (type) {
            case "Point": {
                return new PointGeometry(GeometryDeserializer.readCoordinate(coordinates), boundingBox, properties);
            }
            case "LineString": {
                return new LineGeometry(GeometryDeserializer.readCoordinates(coordinates), boundingBox, properties);
            }
            case "Polygon": {
                ArrayList<LineGeometry> rings = new ArrayList<LineGeometry>();
                coordinates.forEach(ring -> rings.add(new LineGeometry(GeometryDeserializer.readCoordinates(ring))));
                return new PolygonGeometry(rings, boundingBox, properties);
            }
            case "MultiPoint": {
                ArrayList<PointGeometry> points = new ArrayList<PointGeometry>();
                GeometryDeserializer.readCoordinates(coordinates).forEach(position -> points.add(new PointGeometry((GeometryPosition)position)));
                return new MultiPointGeometry(points, boundingBox, properties);
            }
            case "MultiLineString": {
                ArrayList<LineGeometry> lines = new ArrayList<LineGeometry>();
                coordinates.forEach(line -> lines.add(new LineGeometry(GeometryDeserializer.readCoordinates(line))));
                return new MultiLineGeometry(lines, boundingBox, properties);
            }
            case "MultiPolygon": {
                return GeometryDeserializer.readMultiPolygon(coordinates, boundingBox, properties);
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Unsupported geometry type %s.", type)));
    }

    private static MultiPolygonGeometry readMultiPolygon(JsonNode node, GeometryBoundingBox boundingBox, Map<String, Object> properties) {
        ArrayList<PolygonGeometry> polygons = new ArrayList<PolygonGeometry>();
        for (JsonNode polygon : node) {
            ArrayList<LineGeometry> rings = new ArrayList<LineGeometry>();
            polygon.forEach(ring -> rings.add(new LineGeometry(GeometryDeserializer.readCoordinates(ring))));
            polygons.add(new PolygonGeometry(rings));
        }
        return new MultiPolygonGeometry(polygons, boundingBox, properties);
    }

    private static JsonNode getRequiredProperty(JsonNode node, String name) {
        JsonNode requiredNode = node.get(name);
        if (requiredNode == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("GeoJSON object expected to have '%s' property.", name)));
        }
        return requiredNode;
    }

    private static GeometryBoundingBox readBoundingBox(JsonNode node) {
        JsonNode boundingBoxNode = node.get(BOUNDING_BOX_PROPERTY);
        if (boundingBoxNode != null) {
            switch (boundingBoxNode.size()) {
                case 4: {
                    return new GeometryBoundingBox(boundingBoxNode.get(0).asDouble(), boundingBoxNode.get(1).asDouble(), boundingBoxNode.get(2).asDouble(), boundingBoxNode.get(3).asDouble());
                }
                case 6: {
                    return new GeometryBoundingBox(boundingBoxNode.get(0).asDouble(), boundingBoxNode.get(1).asDouble(), boundingBoxNode.get(3).asDouble(), boundingBoxNode.get(4).asDouble(), boundingBoxNode.get(2).asDouble(), boundingBoxNode.get(5).asDouble());
                }
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Only 2 or 3 dimension bounding boxes are supported."));
        }
        return null;
    }

    private static Map<String, Object> readProperties(JsonNode node) {
        return GeometryDeserializer.readProperties(node, COORDINATES_PROPERTY);
    }

    private static Map<String, Object> readProperties(JsonNode node, String knownProperty) {
        HashMap<String, Object> additionalProperties = null;
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            String propertyName = (String)field.getKey();
            if (propertyName.equalsIgnoreCase(TYPE_PROPERTY) || propertyName.equalsIgnoreCase(BOUNDING_BOX_PROPERTY) || propertyName.equalsIgnoreCase(knownProperty)) continue;
            if (additionalProperties == null) {
                additionalProperties = new HashMap<String, Object>();
            }
            additionalProperties.put(propertyName, GeometryDeserializer.readAdditionalPropertyValue((JsonNode)field.getValue()));
        }
        return additionalProperties;
    }

    private static Object readAdditionalPropertyValue(JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return node.asText();
            }
            case NUMBER: {
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                if (node.isFloat()) {
                    return Float.valueOf(node.floatValue());
                }
                return node.asDouble();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NULL: 
            case MISSING: {
                return null;
            }
            case OBJECT: {
                HashMap object = new HashMap();
                node.fields().forEachRemaining(field -> object.put((String)field.getKey(), GeometryDeserializer.readAdditionalPropertyValue((JsonNode)field.getValue())));
                return object;
            }
            case ARRAY: {
                ArrayList array = new ArrayList();
                node.forEach(element -> array.add(GeometryDeserializer.readAdditionalPropertyValue(element)));
                return array;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Unsupported additional property type %s.", node.getNodeType())));
    }

    private static List<GeometryPosition> readCoordinates(JsonNode coordinates) {
        ArrayList<GeometryPosition> positions = new ArrayList<GeometryPosition>();
        coordinates.forEach(coordinate -> positions.add(GeometryDeserializer.readCoordinate(coordinate)));
        return positions;
    }

    private static GeometryPosition readCoordinate(JsonNode coordinate) {
        int coordinateCount = coordinate.size();
        if (coordinateCount < 2 || coordinateCount > 3) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Only 2 or 3 element coordinates supported."));
        }
        double longitude = coordinate.get(0).asDouble();
        double latitude = coordinate.get(1).asDouble();
        Double altitude = null;
        if (coordinateCount > 2) {
            altitude = coordinate.get(2).asDouble();
        }
        return new GeometryPosition(longitude, latitude, altitude);
    }

    private static <T extends Geometry> JsonDeserializer<T> geometrySubclassDeserializer(final Class<T> subclass) {
        return new JsonDeserializer<T>(){

            public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return (Geometry)subclass.cast(GeometryDeserializer.read(ctxt.readTree(p)));
            }
        };
    }
}

