/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.implementation;

import com.azure.core.experimental.implementation.AzureEnvironment;
import com.azure.core.http.HttpRequest;
import java.util.Locale;
import java.util.Map;

public final class ARMScopeHelper {
    private ARMScopeHelper() {
    }

    public static String getDefaultScopeFromRequest(HttpRequest request, AzureEnvironment environment) {
        return ARMScopeHelper.getDefaultScopeFromUrl(request.getUrl().toString().toLowerCase(Locale.US), environment);
    }

    static String getDefaultScopeFromUrl(String url, AzureEnvironment environment) {
        String resource = environment.getManagementEndpoint();
        for (Map.Entry<String, String> endpoint : environment.getEndpoints().entrySet()) {
            if (!url.contains(endpoint.getValue())) continue;
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.KEYVAULT.identifier())) {
                resource = String.format("https://%s/", endpoint.getValue().replaceAll("^\\.*", ""));
                break;
            }
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.GRAPH.identifier())) {
                resource = environment.getGraphEndpoint();
                break;
            }
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.MICROSOFT_GRAPH.identifier())) {
                resource = environment.getMicrosoftGraphEndpoint();
                break;
            }
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.LOG_ANALYTICS.identifier())) {
                resource = environment.getLogAnalyticsEndpoint();
                break;
            }
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.APPLICATION_INSIGHTS.identifier())) {
                resource = environment.getApplicationInsightsEndpoint();
                break;
            }
            if (!endpoint.getKey().equals(AzureEnvironment.Endpoint.DATA_LAKE_STORE.identifier()) && !endpoint.getKey().equals(AzureEnvironment.Endpoint.DATA_LAKE_ANALYTICS.identifier())) continue;
            resource = environment.getDataLakeEndpointResourceId();
            break;
        }
        return ARMScopeHelper.removeTrailingSlash(resource) + "/.default";
    }

    private static String removeTrailingSlash(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }
}

