/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.http.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.experimental.http.policy.BearerTokenAuthenticationChallengePolicy;
import com.azure.core.experimental.implementation.ARMScopeHelper;
import com.azure.core.experimental.implementation.AuthenticationChallenge;
import com.azure.core.experimental.implementation.AzureEnvironment;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

public class ArmChallengeAuthenticationPolicy
extends BearerTokenAuthenticationChallengePolicy {
    private static final Pattern AUTHENTICATION_CHALLENGE_PATTERN = Pattern.compile("(\\w+) ((?:\\w+=\".*?\"(?:, )?)+)(?:, )?");
    private static final Pattern AUTHENTICATION_CHALLENGE_PARAMS_PATTERN = Pattern.compile("(?:(\\w+)=\"([^\"\"]*)\")+");
    private static final String CLAIMS_PARAMETER = "claims";
    private final String[] scopes;
    private final AzureEnvironment environment;
    private static final String ARM_SCOPES_KEY = "ARMScopes";

    public ArmChallengeAuthenticationPolicy(TokenCredential credential, AzureEnvironment environment, String ... scopes) {
        super(credential, scopes);
        this.scopes = scopes;
        this.environment = environment;
    }

    @Override
    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return Mono.defer(() -> {
            String[] scopes = this.scopes;
            scopes = this.getScopes(context, scopes);
            context.setData(ARM_SCOPES_KEY, (Object)scopes);
            return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(scopes));
        });
    }

    @Override
    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.defer(() -> {
            String authHeader = response.getHeaderValue("WWW-Authenticate");
            if (response.getStatusCode() != 401 || authHeader == null) {
                return Mono.just((Object)false);
            }
            List<AuthenticationChallenge> challenges = this.parseChallenges(authHeader);
            for (AuthenticationChallenge authenticationChallenge : challenges) {
                String[] scopes;
                Map<String, String> extractedChallengeParams = this.parseChallengeParams(authenticationChallenge.getChallengeParameters());
                if (!extractedChallengeParams.containsKey(CLAIMS_PARAMETER)) continue;
                String claims = new String(Base64.getUrlDecoder().decode(extractedChallengeParams.get(CLAIMS_PARAMETER)), StandardCharsets.UTF_8);
                try {
                    scopes = (String[])context.getData(ARM_SCOPES_KEY).get();
                }
                catch (NoSuchElementException e) {
                    scopes = this.scopes;
                }
                scopes = this.getScopes(context, scopes);
                return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(scopes).setClaims(claims)).flatMap(b -> Mono.just((Object)true));
            }
            return Mono.just((Object)false);
        });
    }

    private String[] getScopes(HttpPipelineCallContext context, String[] scopes) {
        if (CoreUtils.isNullOrEmpty((Object[])scopes)) {
            scopes = new String[]{ARMScopeHelper.getDefaultScopeFromRequest(context.getHttpRequest(), this.environment)};
        }
        return scopes;
    }

    List<AuthenticationChallenge> parseChallenges(String header) {
        Matcher matcher = AUTHENTICATION_CHALLENGE_PATTERN.matcher(header);
        ArrayList<AuthenticationChallenge> challenges = new ArrayList<AuthenticationChallenge>();
        while (matcher.find()) {
            challenges.add(new AuthenticationChallenge(matcher.group(1), matcher.group(2)));
        }
        return challenges;
    }

    Map<String, String> parseChallengeParams(String challengeParams) {
        Matcher matcher = AUTHENTICATION_CHALLENGE_PARAMS_PATTERN.matcher(challengeParams);
        HashMap<String, String> challengeParameters = new HashMap<String, String>();
        while (matcher.find()) {
            challengeParameters.put(matcher.group(1), matcher.group(2));
        }
        return challengeParameters;
    }
}

