/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.models;

import com.azure.containers.containerregistry.models.OciAnnotations;
import com.azure.containers.containerregistry.models.OciDescriptor;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OciImageManifest
implements JsonSerializable<OciImageManifest> {
    private OciDescriptor configuration;
    private List<OciDescriptor> layers;
    private OciAnnotations annotations;
    private int schemaVersion;

    public OciDescriptor getConfiguration() {
        return this.configuration;
    }

    public OciImageManifest setConfiguration(OciDescriptor configuration) {
        this.configuration = configuration;
        return this;
    }

    public List<OciDescriptor> getLayers() {
        return this.layers;
    }

    public OciImageManifest setLayers(List<OciDescriptor> layers) {
        this.layers = layers;
        return this;
    }

    public OciAnnotations getAnnotations() {
        return this.annotations;
    }

    public OciImageManifest setAnnotations(OciAnnotations annotations) {
        this.annotations = annotations;
        return this;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public OciImageManifest setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("schemaVersion", this.schemaVersion);
        jsonWriter.writeJsonField("config", (JsonSerializable)this.configuration);
        jsonWriter.writeArrayField("layers", this.layers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("annotations", (JsonSerializable)this.annotations);
        return jsonWriter.writeEndObject();
    }

    public static OciImageManifest fromJson(JsonReader jsonReader) throws IOException {
        return (OciImageManifest)jsonReader.readObject(reader -> {
            OciImageManifest deserializedOciImageManifest = new OciImageManifest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedOciImageManifest.schemaVersion = reader.getInt();
                    continue;
                }
                if ("config".equals(fieldName)) {
                    deserializedOciImageManifest.configuration = OciDescriptor.fromJson(reader);
                    continue;
                }
                if ("layers".equals(fieldName)) {
                    List layers;
                    deserializedOciImageManifest.layers = layers = reader.readArray(reader1 -> OciDescriptor.fromJson(reader1));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    deserializedOciImageManifest.annotations = OciAnnotations.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOciImageManifest;
        });
    }
}

