/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.models;

import com.azure.containers.containerregistry.models.OciAnnotations;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OciDescriptor
implements JsonSerializable<OciDescriptor> {
    private String mediaType;
    private Long sizeInBytes;
    private String digest;
    private List<String> urls;
    private OciAnnotations annotations;

    public String getMediaType() {
        return this.mediaType;
    }

    public OciDescriptor setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public OciDescriptor setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public String getDigest() {
        return this.digest;
    }

    public OciDescriptor setDigest(String digest) {
        this.digest = digest;
        return this;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public OciDescriptor setUrls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    public OciAnnotations getAnnotations() {
        return this.annotations;
    }

    public OciDescriptor setAnnotations(OciAnnotations annotations) {
        this.annotations = annotations;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeNumberField("size", (Number)this.sizeInBytes);
        jsonWriter.writeStringField("digest", this.digest);
        jsonWriter.writeArrayField("urls", this.urls, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("annotations", (JsonSerializable)this.annotations);
        return jsonWriter.writeEndObject();
    }

    public static OciDescriptor fromJson(JsonReader jsonReader) throws IOException {
        return (OciDescriptor)jsonReader.readObject(reader -> {
            OciDescriptor deserializedOciDescriptor = new OciDescriptor();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mediaType".equals(fieldName)) {
                    deserializedOciDescriptor.mediaType = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedOciDescriptor.sizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("digest".equals(fieldName)) {
                    deserializedOciDescriptor.digest = reader.getString();
                    continue;
                }
                if ("urls".equals(fieldName)) {
                    List urls;
                    deserializedOciDescriptor.urls = urls = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    deserializedOciDescriptor.annotations = OciAnnotations.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOciDescriptor;
        });
    }
}

