/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class OciAnnotations
implements JsonSerializable<OciAnnotations> {
    private OffsetDateTime createdOn;
    private String authors;
    private String url;
    private String documentation;
    private String source;
    private String version;
    private String revision;
    private String vendor;
    private String licenses;
    private String name;
    private String title;
    private String description;
    private Map<String, Object> additionalProperties;

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OciAnnotations setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public String getAuthors() {
        return this.authors;
    }

    public OciAnnotations setAuthors(String authors) {
        this.authors = authors;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public OciAnnotations setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public OciAnnotations setDocumentation(String documentation) {
        this.documentation = documentation;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public OciAnnotations setSource(String source) {
        this.source = source;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public OciAnnotations setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public OciAnnotations setRevision(String revision) {
        this.revision = revision;
        return this;
    }

    public String getVendor() {
        return this.vendor;
    }

    public OciAnnotations setVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public String getLicenses() {
        return this.licenses;
    }

    public OciAnnotations setLicenses(String licenses) {
        this.licenses = licenses;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public OciAnnotations setName(String name) {
        this.name = name;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public OciAnnotations setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public OciAnnotations setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public OciAnnotations setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("org.opencontainers.image.created", Objects.toString(this.createdOn, null));
        jsonWriter.writeStringField("org.opencontainers.image.authors", this.authors);
        jsonWriter.writeStringField("org.opencontainers.image.url", this.url);
        jsonWriter.writeStringField("org.opencontainers.image.documentation", this.documentation);
        jsonWriter.writeStringField("org.opencontainers.image.source", this.source);
        jsonWriter.writeStringField("org.opencontainers.image.version", this.version);
        jsonWriter.writeStringField("org.opencontainers.image.revision", this.revision);
        jsonWriter.writeStringField("org.opencontainers.image.vendor", this.vendor);
        jsonWriter.writeStringField("org.opencontainers.image.licenses", this.licenses);
        jsonWriter.writeStringField("org.opencontainers.image.ref.name", this.name);
        jsonWriter.writeStringField("org.opencontainers.image.title", this.title);
        jsonWriter.writeStringField("org.opencontainers.image.description", this.description);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OciAnnotations fromJson(JsonReader jsonReader) throws IOException {
        return (OciAnnotations)jsonReader.readObject(reader -> {
            OciAnnotations deserializedOciAnnotations = new OciAnnotations();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("org.opencontainers.image.created".equals(fieldName)) {
                    deserializedOciAnnotations.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("org.opencontainers.image.authors".equals(fieldName)) {
                    deserializedOciAnnotations.authors = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.url".equals(fieldName)) {
                    deserializedOciAnnotations.url = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.documentation".equals(fieldName)) {
                    deserializedOciAnnotations.documentation = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.source".equals(fieldName)) {
                    deserializedOciAnnotations.source = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.version".equals(fieldName)) {
                    deserializedOciAnnotations.version = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.revision".equals(fieldName)) {
                    deserializedOciAnnotations.revision = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.vendor".equals(fieldName)) {
                    deserializedOciAnnotations.vendor = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.licenses".equals(fieldName)) {
                    deserializedOciAnnotations.licenses = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.ref.name".equals(fieldName)) {
                    deserializedOciAnnotations.name = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.title".equals(fieldName)) {
                    deserializedOciAnnotations.title = reader.getString();
                    continue;
                }
                if ("org.opencontainers.image.description".equals(fieldName)) {
                    deserializedOciAnnotations.description = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOciAnnotations.additionalProperties = additionalProperties;
            return deserializedOciAnnotations;
        });
    }
}

