/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class ContainerRepositoryProperties
implements JsonSerializable<ContainerRepositoryProperties> {
    private String registryLoginServer;
    private String name;
    private OffsetDateTime createdOn;
    private OffsetDateTime lastUpdatedOn;
    private int manifestCount;
    private int tagCount;
    private Boolean deleteEnabled;
    private Boolean writeEnabled;
    private Boolean listEnabled;
    private Boolean readEnabled;

    public String getRegistryLoginServer() {
        return this.registryLoginServer;
    }

    public String getName() {
        return this.name;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public int getManifestCount() {
        return this.manifestCount;
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public Boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public ContainerRepositoryProperties setDeleteEnabled(Boolean deleteEnabled) {
        this.deleteEnabled = deleteEnabled;
        return this;
    }

    public Boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public ContainerRepositoryProperties setWriteEnabled(Boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
        return this;
    }

    public Boolean isListEnabled() {
        return this.listEnabled;
    }

    public ContainerRepositoryProperties setListEnabled(Boolean listEnabled) {
        this.listEnabled = listEnabled;
        return this;
    }

    public Boolean isReadEnabled() {
        return this.readEnabled;
    }

    public ContainerRepositoryProperties setReadEnabled(Boolean readEnabled) {
        this.readEnabled = readEnabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("registry", this.registryLoginServer);
        jsonWriter.writeStringField("imageName", this.name);
        jsonWriter.writeStringField("createdTime", Objects.toString(this.createdOn, null));
        jsonWriter.writeStringField("lastUpdateTime", Objects.toString(this.lastUpdatedOn, null));
        jsonWriter.writeIntField("manifestCount", this.manifestCount);
        jsonWriter.writeIntField("tagCount", this.tagCount);
        if (this.deleteEnabled != null || this.writeEnabled != null || this.listEnabled != null || this.readEnabled != null) {
            jsonWriter.writeStartObject("changeableAttributes");
            jsonWriter.writeBooleanField("deleteEnabled", this.deleteEnabled);
            jsonWriter.writeBooleanField("writeEnabled", this.writeEnabled);
            jsonWriter.writeBooleanField("listEnabled", this.listEnabled);
            jsonWriter.writeBooleanField("readEnabled", this.readEnabled);
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static ContainerRepositoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRepositoryProperties)jsonReader.readObject(reader -> {
            ContainerRepositoryProperties deserializedContainerRepositoryProperties = new ContainerRepositoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registry".equals(fieldName)) {
                    deserializedContainerRepositoryProperties.registryLoginServer = reader.getString();
                    continue;
                }
                if ("imageName".equals(fieldName)) {
                    deserializedContainerRepositoryProperties.name = reader.getString();
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedContainerRepositoryProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    deserializedContainerRepositoryProperties.lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("manifestCount".equals(fieldName)) {
                    deserializedContainerRepositoryProperties.manifestCount = reader.getInt();
                    continue;
                }
                if ("tagCount".equals(fieldName)) {
                    deserializedContainerRepositoryProperties.tagCount = reader.getInt();
                    continue;
                }
                if ("changeableAttributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("deleteEnabled".equals(fieldName)) {
                            deserializedContainerRepositoryProperties.deleteEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("writeEnabled".equals(fieldName)) {
                            deserializedContainerRepositoryProperties.writeEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("listEnabled".equals(fieldName)) {
                            deserializedContainerRepositoryProperties.listEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("readEnabled".equals(fieldName)) {
                            deserializedContainerRepositoryProperties.readEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRepositoryProperties;
        });
    }
}

