/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.Manifest;
import com.azure.containers.containerregistry.models.OciDescriptor;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class V2Manifest
extends Manifest {
    private String mediaType;
    private OciDescriptor config;
    private List<OciDescriptor> layers;

    public String getMediaType() {
        return this.mediaType;
    }

    public V2Manifest setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public OciDescriptor getConfig() {
        return this.config;
    }

    public V2Manifest setConfig(OciDescriptor config) {
        this.config = config;
        return this;
    }

    public List<OciDescriptor> getLayers() {
        return this.layers;
    }

    public V2Manifest setLayers(List<OciDescriptor> layers) {
        this.layers = layers;
        return this;
    }

    @Override
    public V2Manifest setSchemaVersion(Integer schemaVersion) {
        super.setSchemaVersion(schemaVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("schemaVersion", (Number)this.getSchemaVersion());
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeJsonField("config", (JsonSerializable)this.config);
        jsonWriter.writeArrayField("layers", this.layers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static V2Manifest fromJson(JsonReader jsonReader) throws IOException {
        return (V2Manifest)jsonReader.readObject(reader -> {
            V2Manifest deserializedV2Manifest = new V2Manifest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedV2Manifest.setSchemaVersion((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("mediaType".equals(fieldName)) {
                    deserializedV2Manifest.mediaType = reader.getString();
                    continue;
                }
                if ("config".equals(fieldName)) {
                    deserializedV2Manifest.config = OciDescriptor.fromJson(reader);
                    continue;
                }
                if ("layers".equals(fieldName)) {
                    List layers;
                    deserializedV2Manifest.layers = layers = reader.readArray(reader1 -> OciDescriptor.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedV2Manifest;
        });
    }
}

